/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities.optionlet;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.termstructures.volatilities.SmileSection;
import org.jquantlib.termstructures.volatilities.VolatilityTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;

public abstract class OptionletVolatilityStructure
extends VolatilityTermStructure {
    public OptionletVolatilityStructure(Calendar cal, BusinessDayConvention bdc) {
        this(cal, bdc, new DayCounter());
    }

    public OptionletVolatilityStructure(Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(cal, bdc, dc);
    }

    public OptionletVolatilityStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc) {
        super(referenceDate, cal, bdc, new DayCounter());
    }

    public OptionletVolatilityStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(referenceDate, cal, bdc, dc);
    }

    public OptionletVolatilityStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(settlementDays, cal, bdc, dc);
    }

    public OptionletVolatilityStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc) {
        this(settlementDays, cal, bdc, new DayCounter());
    }

    public double volatility(Period optionTenor, double strike) {
        return this.volatility(optionTenor, strike, false);
    }

    public double volatility(Date optionDate, double strike) {
        return this.volatility(optionDate, strike, false);
    }

    public double volatility(@Time double optionTime, double strike) {
        return this.volatility(optionTime, strike, false);
    }

    public double blackVariance(Period optionTenor, double strike) {
        return this.blackVariance(optionTenor, strike, false);
    }

    public double blackVariance(Date optionDate, double strike) {
        return this.blackVariance(optionDate, strike, false);
    }

    public double blackVariance(@Time double optionTime, double strike) {
        return this.blackVariance(optionTime, strike, false);
    }

    public SmileSection smileSection(Period optionTenor) {
        return this.smileSection(optionTenor, false);
    }

    public SmileSection smileSection(Date optionDate) {
        return this.smileSection(optionDate, false);
    }

    public SmileSection smileSection(@Time double optionTime) {
        return this.smileSection(optionTime, false);
    }

    protected abstract SmileSection smileSectionImpl(@Time double var1);

    protected abstract double volatilityImpl(double var1, double var3);

    public double volatility(Period optionTenor, double strike, boolean extrapolate) {
        Date optionDate = this.optionDateFromTenor(optionTenor);
        return this.volatility(optionDate, strike, extrapolate);
    }

    public double blackVariance(Period optionTenor, double strike, boolean extrapolate) {
        Date optionDate = this.optionDateFromTenor(optionTenor);
        return this.blackVariance(optionDate, strike, extrapolate);
    }

    public SmileSection smileSection(Period optionTenor, boolean extrapolate) {
        Date optionDate = this.optionDateFromTenor(optionTenor);
        return this.smileSection(optionDate, extrapolate);
    }

    public double blackVariance(Date optionDate, double strike, boolean extrapolate) {
        double v = this.volatility(optionDate, strike, extrapolate);
        double t = this.timeFromReference(optionDate);
        return v * v * t;
    }

    public double blackVariance(double optionTime, double strike, boolean extrapolate) {
        double v = this.volatility(optionTime, strike, extrapolate);
        return v * v * optionTime;
    }

    public double volatility(Date optionDate, double strike, boolean extrapolate) {
        this.checkRange(optionDate, extrapolate);
        this.checkStrike(strike, extrapolate);
        return this.volatilityImpl(optionDate, strike);
    }

    public double volatility(@Time double optionTime, double strike, boolean extrapolate) {
        this.checkRange(optionTime, extrapolate);
        this.checkStrike(strike, extrapolate);
        return this.volatilityImpl(optionTime, strike);
    }

    public SmileSection smileSection(Date optionDate, boolean extr) {
        this.checkRange(optionDate, extr);
        return this.smileSectionImpl(optionDate);
    }

    public SmileSection smileSection(@Time double optionTime, boolean extrapolate) {
        this.checkRange(optionTime, extrapolate);
        return this.smileSectionImpl(optionTime);
    }

    protected SmileSection smileSectionImpl(Date optionDate) {
        return this.smileSectionImpl(this.timeFromReference(optionDate));
    }

    public double volatilityImpl(Date optionDate, double strike) {
        return this.volatilityImpl(this.timeFromReference(optionDate), strike);
    }
}

