/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities.optionlet;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.volatilities.FlatSmileSection;
import org.jquantlib.termstructures.volatilities.SmileSection;
import org.jquantlib.termstructures.volatilities.optionlet.OptionletVolatilityStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;

public class ConstantOptionletVolatility
extends OptionletVolatilityStructure {
    private final Handle<Quote> volatility_;

    public ConstantOptionletVolatility(int settlementDays, Calendar cal, BusinessDayConvention bdc, Handle<Quote> vol, DayCounter dc) {
        super(settlementDays, cal, bdc, dc);
        this.volatility_ = vol;
        this.volatility_.addObserver(this);
    }

    public ConstantOptionletVolatility(Date referenceDate, Calendar cal, BusinessDayConvention bdc, Handle<Quote> vol, DayCounter dc) {
        super(referenceDate, cal, bdc, dc);
        this.volatility_ = vol;
        this.volatility_.addObserver(this);
    }

    public ConstantOptionletVolatility(int settlementDays, Calendar cal, BusinessDayConvention bdc, double vol, DayCounter dc) {
        super(settlementDays, cal, bdc, dc);
        this.volatility_ = new Handle<SimpleQuote>(new SimpleQuote(vol));
    }

    public ConstantOptionletVolatility(Date referenceDate, Calendar cal, BusinessDayConvention bdc, double vol, DayCounter dc) {
        super(referenceDate, cal, bdc, dc);
        this.volatility_ = new Handle<SimpleQuote>(new SimpleQuote(vol));
    }

    @Override
    public Date maxDate() {
        return Date.maxDate();
    }

    @Override
    public double minStrike() {
        return -1.7976931348623157E308;
    }

    @Override
    public double maxStrike() {
        return Double.MAX_VALUE;
    }

    @Override
    protected SmileSection smileSectionImpl(Date d) {
        double atmVol = this.volatility_.currentLink().value();
        return new FlatSmileSection(d, atmVol, this.dayCounter(), this.referenceDate());
    }

    @Override
    protected SmileSection smileSectionImpl(double optionTime) {
        double atmVol = this.volatility_.currentLink().value();
        return new FlatSmileSection(optionTime, atmVol, this.dayCounter());
    }

    @Override
    protected double volatilityImpl(double time, double rate) {
        return this.volatility_.currentLink().value();
    }
}

