/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.time.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class SmileSection
implements Observer,
Observable {
    private Date exerciseDate_;
    private Date reference_;
    private final DayCounter dc_;
    private final boolean isFloating_;
    protected double exerciseTime_;
    private final DefaultObservable delegatedObservable = new DefaultObservable(this);

    public SmileSection(Date d, DayCounter dc, Date referenceDate) {
        this.exerciseDate_ = d;
        this.dc_ = dc;
        this.isFloating_ = referenceDate.isNull();
        if (this.isFloating_) {
            Settings settings = new Settings();
            settings.evaluationDate().addObserver(this);
            this.reference_ = settings.evaluationDate();
        } else {
            this.reference_ = referenceDate;
        }
        this.initializeExerciseTime();
    }

    public SmileSection(double exerciseTime, DayCounter dc) {
        this.isFloating_ = false;
        this.dc_ = dc;
        this.exerciseTime_ = exerciseTime;
        QL.require(this.exerciseTime_ >= 0.0, "expiry time must be positive: " + this.exerciseTime_ + " not allowed");
    }

    public abstract double minStrike();

    public abstract double maxStrike();

    public abstract double atmLevel();

    protected abstract double volatilityImpl(double var1);

    public double variance() {
        return this.variance(Double.MAX_VALUE);
    }

    public double volatility() {
        return this.volatility(Double.MAX_VALUE);
    }

    public void initializeExerciseTime() {
        QL.require(this.exerciseDate_.ge(this.reference_), "expiry date (" + this.exerciseDate_ + ") must be greater than reference date (" + this.reference_ + ")");
        this.exerciseTime_ = this.dc_.yearFraction(this.reference_, this.exerciseDate_);
    }

    public double variance(double strike) {
        if (Double.isNaN(strike)) {
            strike = this.atmLevel();
        }
        return this.varianceImpl(strike);
    }

    public double volatility(double strike) {
        if (Double.isNaN(strike)) {
            strike = this.atmLevel();
        }
        return this.volatilityImpl(strike);
    }

    public Date exerciseDate() {
        return this.exerciseDate_;
    }

    public double exerciseTime() {
        return this.exerciseTime_;
    }

    public DayCounter dayCounter() {
        return this.dc_;
    }

    protected double varianceImpl(double strike) {
        double v = this.volatilityImpl(strike);
        return v * v * this.exerciseTime();
    }

    @Override
    public void update() {
        if (this.isFloating_) {
            Settings settings = new Settings();
            this.reference_ = settings.evaluationDate();
            this.initializeExerciseTime();
        }
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }
}

