/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.QL;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.Constants;

public class Sabr {
    public double unsafeSabrVolatility(double strike, double forward, double expiryTime, double alpha, double beta, double nu, double rho) {
        double multiplier;
        double logM;
        double oneMinusBeta = 1.0 - beta;
        double A = Math.pow(forward * strike, oneMinusBeta);
        double sqrtA = Math.sqrt(A);
        if (!Closeness.isClose(forward, strike)) {
            logM = Math.log(forward / strike);
        } else {
            double epsilon = (forward - strike) / strike;
            logM = epsilon - 0.5 * epsilon * epsilon;
        }
        double z = nu / alpha * sqrtA * logM;
        double B = 1.0 - 2.0 * rho * z + z * z;
        double C = oneMinusBeta * oneMinusBeta * logM * logM;
        double tmp = (Math.sqrt(B) + z - rho) / (1.0 - rho);
        double xx = Math.log(tmp);
        double D = sqrtA * (1.0 + C / 24.0 + C * C / 1920.0);
        double d = 1.0 + expiryTime * (oneMinusBeta * oneMinusBeta * alpha * alpha / (24.0 * A) + 0.25 * rho * beta * nu * alpha / sqrtA + (2.0 - 3.0 * rho * rho) * (nu * nu / 24.0));
        double m = 10.0;
        if (Math.abs(z * z) > Constants.QL_EPSILON * 10.0) {
            multiplier = z / xx;
        } else {
            double talpha = (0.5 - rho * rho) / (1.0 - rho);
            double tbeta = alpha - 0.5;
            double tgamma = rho / (1.0 - rho);
            multiplier = 1.0 - beta * z + (tgamma - talpha + tbeta * tbeta * 0.5) * z * z;
        }
        return alpha / D * multiplier * d;
    }

    public void validateSabrParameters(double alpha, double beta, double nu, double rho) {
        QL.require(alpha > 0.0, "alpha must be positive");
        QL.require(beta >= 0.0 && beta <= 1.0, "beta must be in (0.0, 1.0)");
        QL.require(nu >= 0.0, "nu must be non negative");
        QL.require(rho * rho < 1.0, "rho square must be less than one");
    }

    public double sabrVolatility(double strike, double forward, double expiryTime, double alpha, double beta, double nu, double rho) {
        QL.require(strike > 0.0, "strike must be positive");
        QL.require(forward > 0.0, "forward must be positive");
        QL.require(expiryTime >= 0.0, "expiry time must be non-negative");
        this.validateSabrParameters(alpha, beta, nu, rho);
        return this.unsafeSabrVolatility(strike, forward, expiryTime, alpha, beta, nu, rho);
    }
}

