/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.AbstractTermStructure;
import org.jquantlib.termstructures.volatilities.SmileSection;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.util.Pair;

public abstract class SwaptionVolatilityStructure
extends AbstractTermStructure {
    private final BusinessDayConvention bdc_;

    public SwaptionVolatilityStructure(DayCounter dc, BusinessDayConvention bdc) {
        super(dc);
        this.bdc_ = bdc;
    }

    public SwaptionVolatilityStructure(Date referenceDate, Calendar calendar, DayCounter dc, BusinessDayConvention bdc) {
        super(referenceDate, calendar, dc);
        this.bdc_ = bdc;
    }

    public SwaptionVolatilityStructure(int settlementDays, Calendar calendar, DayCounter dc, BusinessDayConvention bdc) {
        super(settlementDays, calendar, dc);
        this.bdc_ = bdc;
    }

    public double volatility(double optionTime, double swapLength, double strike) {
        return this.volatility(optionTime, swapLength, strike, false);
    }

    public abstract double blackVariance(double var1, double var3, double var5, boolean var7);

    public double blackVariance(double optionTime, double swapLength, double strike) {
        return this.blackVariance(optionTime, swapLength, strike, false);
    }

    public double volatility(Period optionTenor, Period swapTenor, double strike) {
        return this.volatility(optionTenor, swapTenor, strike, false);
    }

    public double blackVariance(Period optionTenor, Period swapTenor, double strike) {
        return this.blackVariance(optionTenor, swapTenor, strike, false);
    }

    public abstract Period maxSwapTenor();

    public abstract double minStrike();

    public abstract double maxStrike();

    public abstract BusinessDayConvention businessDayConvention();

    protected abstract SmileSection smileSectionImpl(double var1, double var3);

    protected abstract SmileSection smileSectionImpl(Date var1, Period var2);

    public abstract double volatilityImpl(double var1, double var3, double var5);

    protected double volatilityImpl(Date optionDate, Period swapTenor, double strike) {
        Pair<Double, Double> p = this.convertDates(optionDate, swapTenor);
        return this.volatilityImpl(p.first(), p.second(), strike);
    }

    public Date optionDateFromTenor(Period optionTenor) {
        return this.calendar().advance(this.referenceDate(), optionTenor, this.businessDayConvention());
    }

    public double volatility(double optionTime, double swapLength, double strike, boolean extrapolate) {
        this.checkRange(optionTime, swapLength, strike, extrapolate);
        return this.volatilityImpl(optionTime, swapLength, strike);
    }

    public double blackVariance(double optionTime, double swapLength, double strike, Boolean extrapolate) {
        this.checkRange(optionTime, swapLength, strike, (boolean)extrapolate);
        double vol = this.volatilityImpl(optionTime, swapLength, strike);
        return vol * vol * optionTime;
    }

    public double volatility(Date optionDate, Period swapTenor, double strike, boolean extrapolate) {
        this.checkRange(optionDate, swapTenor, strike, extrapolate);
        return this.volatilityImpl(optionDate, swapTenor, strike);
    }

    public double blackVariance(Date optionDate, Period swapTenor, double strike, boolean extrapolate) {
        double vol = this.volatility(optionDate, swapTenor, strike, extrapolate);
        Pair<Double, Double> p = this.convertDates(optionDate, swapTenor);
        return vol * vol * p.first();
    }

    public double volatility(Period optionTenor, Period swapTenor, double strike, boolean extrapolate) {
        Date optionDate = this.optionDateFromTenor(optionTenor);
        return this.volatility(optionDate, swapTenor, strike, extrapolate);
    }

    public double blackVariance(Period optionTenor, Period swapTenor, double strike, boolean extrapolate) {
        Date optionDate = this.optionDateFromTenor(optionTenor);
        double vol = this.volatility(optionDate, swapTenor, strike, extrapolate);
        Pair<Double, Double> p = this.convertDates(optionDate, swapTenor);
        return vol * vol * p.first();
    }

    public SmileSection smileSection(Period optionTenor, Period swapTenor) {
        Date optionDate = this.optionDateFromTenor(optionTenor);
        return this.smileSectionImpl(optionDate, swapTenor);
    }

    public void checkRange(double optionTime, double swapLength, double k, boolean extrapolate) {
        super.checkRange(optionTime, extrapolate);
        if (swapLength < 0.0) {
            throw new IllegalArgumentException("negative swapLength (" + swapLength + ") given");
        }
        if (!extrapolate && !this.allowsExtrapolation() && swapLength > this.maxSwapLength()) {
            throw new IllegalArgumentException("swapLength (" + swapLength + ") is past max curve swapLength (" + this.maxSwapLength() + ")");
        }
        if (!extrapolate && !this.allowsExtrapolation() && (k < this.minStrike() || k > this.maxStrike())) {
            throw new IllegalArgumentException("strike (" + k + ") is outside the curve domain [" + this.minStrike() + "," + this.maxStrike() + "]");
        }
    }

    public double maxSwapLength() {
        return this.timeFromReference(this.referenceDate().add(this.maxSwapTenor()));
    }

    public Pair<Double, Double> convertDates(Date optionDate, Period swapTenor) {
        Date end = optionDate.add(swapTenor);
        QL.require(end.gt(optionDate), "negative swap tenorgiven");
        double optionTime = this.timeFromReference(optionDate);
        double timeLength = this.dayCounter().yearFraction(optionDate, end);
        return new Pair<Double, Double>(optionTime, timeLength);
    }

    protected void checkRange(Date optionDate, Period swapTenor, double k, boolean extrapolate) {
        super.checkRange(this.timeFromReference(optionDate), extrapolate);
        if (swapTenor.length() <= 0) {
            throw new IllegalArgumentException("negative swap tenor (" + swapTenor + ") given");
        }
        if (!extrapolate && !this.allowsExtrapolation() && swapTenor.gt(this.maxSwapTenor())) {
            throw new IllegalArgumentException("swap tenor (" + swapTenor + ") is past max tenor (" + this.maxSwapTenor() + ")");
        }
        if (!extrapolate && !this.allowsExtrapolation() && k >= this.minStrike() && k <= this.maxStrike()) {
            throw new IllegalArgumentException("strike (" + k + ") is outside the curve domain [" + this.minStrike() + "," + this.maxStrike() + "]");
        }
    }
}

