/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.termstructures.volatilities.VolatilityTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitable;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public abstract class LocalVolTermStructure
extends VolatilityTermStructure
implements PolymorphicVisitable {
    public LocalVolTermStructure() {
        this(new Calendar(), BusinessDayConvention.Following, new DayCounter());
    }

    public LocalVolTermStructure(Calendar cal) {
        this(cal, BusinessDayConvention.Following, new DayCounter());
    }

    public LocalVolTermStructure(Calendar cal, BusinessDayConvention bdc) {
        this(cal, bdc, new DayCounter());
    }

    public LocalVolTermStructure(Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(cal, bdc, dc);
    }

    public LocalVolTermStructure(Date referenceDate) {
        this(referenceDate, new Calendar(), BusinessDayConvention.Following, new DayCounter());
    }

    public LocalVolTermStructure(Date referenceDate, Calendar cal) {
        this(referenceDate, cal, BusinessDayConvention.Following, new DayCounter());
    }

    public LocalVolTermStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc) {
        this(referenceDate, cal, bdc, new DayCounter());
    }

    public LocalVolTermStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(referenceDate, cal, bdc, dc);
    }

    public LocalVolTermStructure(int settlementDays, Calendar cal) {
        this(settlementDays, cal, BusinessDayConvention.Following, new DayCounter());
    }

    public LocalVolTermStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc) {
        this(settlementDays, cal, bdc, new DayCounter());
    }

    public LocalVolTermStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(settlementDays, cal, bdc, dc);
    }

    public final double localVol(Date d, double underlyingLevel, boolean extrapolate) {
        double t = this.timeFromReference(d);
        this.checkRange(t, underlyingLevel, extrapolate);
        return this.localVolImpl(t, underlyingLevel);
    }

    public final double localVol(double t, double underlyingLevel) {
        return this.localVol(t, underlyingLevel, false);
    }

    public final double localVol(double t, double underlyingLevel, boolean extrapolate) {
        this.checkRange(t, underlyingLevel, extrapolate);
        return this.localVolImpl(t, underlyingLevel);
    }

    @Override
    public abstract double minStrike();

    @Override
    public abstract double maxStrike();

    protected abstract double localVolImpl(double var1, double var3);

    private final void checkRange(double t, double strike, boolean extrapolate) {
        super.checkRange(t, extrapolate);
        double minStrike = this.minStrike();
        double maxStrike = this.maxStrike();
        QL.require(extrapolate || this.allowsExtrapolation() || strike >= minStrike && strike <= maxStrike, "strike is outside curve domain");
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v == null) {
            throw new LibraryException("not a local-volatility term structure visitor");
        }
        v.visit(this);
    }
}

