/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.QL;
import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.AbstractTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.calendars.NullCalendar;

public abstract class CapVolatilityStructure
extends AbstractTermStructure {
    public CapVolatilityStructure(DayCounter dc) {
        super(dc == null ? new Actual365Fixed() : dc);
    }

    public CapVolatilityStructure(Date referenceDate, Calendar cal, DayCounter dc) {
        super(referenceDate, cal == null ? new NullCalendar() : cal, dc == null ? new Actual365Fixed() : dc);
    }

    public CapVolatilityStructure(int settlementDays, Calendar cal, DayCounter dc) {
        super(settlementDays, cal == null ? new NullCalendar() : cal, dc == null ? new Actual365Fixed() : dc);
    }

    public double volatility(Date end, double strike) {
        return this.volatility(end, strike, false);
    }

    public double volatility(Date end, double strike, boolean extrapolate) {
        double t = this.timeFromReference(end);
        this.checkRange(t, strike, extrapolate);
        return this.volatilityImpl(t, strike);
    }

    public abstract double minStrike();

    public abstract double maxStrike();

    public abstract double volatilityImpl(double var1, double var3);

    public double volatility(Period optionTenor, double strike, boolean extrapolate) {
        Date exerciseDate = this.calendar().advance(this.referenceDate(), optionTenor, BusinessDayConvention.Following);
        return this.volatility(exerciseDate, strike, extrapolate);
    }

    public double volatility(Period length, double strike) {
        return this.volatility(length, strike, false);
    }

    public double volatility(double t, double strike, boolean extrapolate) {
        this.checkRange(t, strike, extrapolate);
        return this.volatilityImpl(t, strike);
    }

    public double volatility(double t, double strike) {
        return this.volatility(t, strike, false);
    }

    private void checkRange(double t, double k, boolean extrapolate) {
        super.checkRange(t, extrapolate);
        QL.require(extrapolate || this.allowsExtrapolation() || k >= this.minStrike() && k <= this.maxStrike(), "strike is outside curve domain");
    }
}

