/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.TermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;
import org.jquantlib.util.PolymorphicVisitable;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public abstract class BootstrapHelper<TS extends TermStructure>
implements Observer,
Observable,
PolymorphicVisitable {
    protected Handle<Quote> quote;
    protected TS termStructure;
    protected Date earliestDate;
    protected Date latestDate;
    private final Observable delegatedObservable = new DefaultObservable(this);

    public BootstrapHelper(Handle<Quote> quote) {
        this.quote = quote;
        this.quote.addObserver(this);
    }

    public BootstrapHelper(double quote) {
        this.quote = new Handle<SimpleQuote>(new SimpleQuote(quote));
    }

    public abstract double impliedQuote();

    public double quoteError() {
        return this.quote.currentLink().value() - this.impliedQuote();
    }

    public boolean quoteIsValid() {
        return this.quote.currentLink().isValid();
    }

    public void setTermStructure(TS c) {
        QL.ensure(c != null, "TermStructure cannot be null");
        this.termStructure = c;
    }

    public Date earliestDate() {
        return this.earliestDate;
    }

    public Date latestDate() {
        return this.latestDate;
    }

    @Override
    public void update() {
        this.notifyObservers();
    }

    @Override
    public final void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public final int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public final void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public final void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public final void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public final void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public final List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v == null) {
            throw new LibraryException("not a bootstrap helper visitor");
        }
        v.visit(this);
    }
}

