/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.quotes;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.quotes.Quote;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class SimpleQuote
extends Quote {
    private double value;

    public SimpleQuote() {
        this(Double.MAX_VALUE);
    }

    public SimpleQuote(SimpleQuote o) {
        this.value = o.value;
    }

    public SimpleQuote(double d) {
        this.value = d;
    }

    public double setValue() {
        return this.setValue(Double.MAX_VALUE);
    }

    public double setValue(double value) {
        double diff = this.value - value;
        if (diff != 0.0) {
            this.value = value;
            this.notifyObservers();
        }
        return diff;
    }

    public void reset() {
        this.setValue(Double.MAX_VALUE);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public final double value() {
        QL.require(this.isValid(), "invalid simple quote: no value available");
        return this.value;
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.value);
    }
}

