/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.time.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class StochasticProcess
implements Observable,
Observer {
    private Discretization discretization;
    private final Observable delegatedObservable = new DefaultObservable(this);

    protected StochasticProcess() {
    }

    protected StochasticProcess(Discretization discretization) {
        QL.require(discretization != null, "null discretization");
        this.discretization = discretization;
    }

    public abstract int size();

    public int factors() {
        return this.size();
    }

    public abstract Array initialValues();

    public abstract Array drift(double var1, Array var3);

    public abstract Matrix diffusion(double var1, Array var3);

    public Array expectation(double t0, Array x0, double dt) {
        return this.apply(x0, this.discretization.driftDiscretization(this, t0, x0, dt));
    }

    public Matrix stdDeviation(double t0, Array x0, double dt) {
        return this.discretization.diffusionDiscretization(this, t0, x0, dt);
    }

    public Matrix covariance(double t0, Array x0, double dt) {
        return this.discretization.covarianceDiscretization(this, t0, x0, dt);
    }

    public Array evolve(double t0, Array x0, double dt, Array dw) {
        return this.apply(this.expectation(t0, x0, dt), this.stdDeviation(t0, x0, dt).mul(dw));
    }

    public Array apply(Array x0, Array dx) {
        return x0.add(dx);
    }

    public double time(Date date) {
        throw new UnsupportedOperationException("date/time conversion not supported");
    }

    @Override
    public void update() {
        this.notifyObservers();
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }

    public static interface Discretization {
        public Array driftDiscretization(StochasticProcess var1, double var2, Array var4, double var5);

        public Matrix diffusionDiscretization(StochasticProcess var1, double var2, Array var4, double var5);

        public Matrix covarianceDiscretization(StochasticProcess var1, double var2, Array var4, double var5);
    }
}

