/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.QL;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.GaussKronrodAdaptive;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;

public abstract class LfmCovarianceParameterization {
    protected int size_;
    private final int factors_;

    public LfmCovarianceParameterization(int size, int factors) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.size_ = size;
        this.factors_ = factors;
    }

    public int size() {
        return this.size_;
    }

    public int factors() {
        return this.factors_;
    }

    public abstract Matrix diffusion(double var1, Array var3);

    public Matrix diffusion(double t) {
        return this.diffusion(t, new Array(0));
    }

    public Matrix covariance(double t, Array x) {
        Matrix sigma = this.diffusion(t, x);
        return sigma.mul(sigma.transpose());
    }

    public Matrix covariance(double t) {
        return this.diffusion(t, new Array(0));
    }

    public Matrix integratedCovariance(double t, Array x) {
        QL.require(!x.empty(), "can not handle given x here");
        Matrix tmp = new Matrix(this.size_, this.size_);
        for (int i = 0; i < this.size_; ++i) {
            for (int j = 0; j <= i; ++j) {
                Var_Helper helper = new Var_Helper(this, i, j);
                GaussKronrodAdaptive integrator = new GaussKronrodAdaptive(1.0E-10, 10000);
                for (int k = 0; k < 64; ++k) {
                    tmp.set(i, j, tmp.get(i, j) + integrator.op(helper, (double)k * t / 64.0, (double)(k + 1) * t / 64.0));
                }
                tmp.set(j, i, tmp.get(i, j));
            }
        }
        return tmp;
    }

    public Matrix integratedCovariance(double t) {
        return this.integratedCovariance(t, new Array(0));
    }

    private static class Var_Helper
    implements Ops.DoubleOp {
        private final int i_;
        private final int j_;
        private final LfmCovarianceParameterization param_;

        public Var_Helper(LfmCovarianceParameterization param, int i, int j) {
            this.i_ = i;
            this.j_ = j;
            this.param_ = param;
        }

        @Override
        public double op(double t) {
            Matrix m = this.param_.diffusion(t);
            return m.constRangeRow(this.i_).innerProduct(m.constRangeRow(this.j_));
        }
    }
}

