/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.math.Constants;
import org.jquantlib.processes.ForwardMeasureProcess1D;
import org.jquantlib.processes.OrnsteinUhlenbeckProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Frequency;

public class HullWhiteForwardProcess
extends ForwardMeasureProcess1D {
    protected OrnsteinUhlenbeckProcess process;
    protected Handle<YieldTermStructure> h;
    protected double a;
    protected double sigma;

    public HullWhiteForwardProcess(Handle<YieldTermStructure> h, double a, double sigma) {
        this.process = new OrnsteinUhlenbeckProcess(a, sigma, h.currentLink().forwardRate(0.0, 0.0, Compounding.Continuous, Frequency.NoFrequency).rate());
        this.h = h;
        this.a = a;
        this.sigma = sigma;
    }

    public double a() {
        return this.a;
    }

    public double sigma() {
        return this.sigma;
    }

    public double alpha(double t) {
        double alfa = this.a > Constants.QL_EPSILON ? this.sigma / this.a * (1.0 - Math.exp(-this.a * t)) : this.sigma * t;
        alfa *= 0.5 * alfa;
        return alfa += this.h.currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency).rate();
    }

    public double M_T(double s, double t, double T) {
        if (this.a > Constants.QL_EPSILON) {
            double coeff = this.sigma * this.sigma / (this.a * this.a);
            double exp1 = Math.exp(-this.a * (t - s));
            double exp2 = Math.exp(-this.a * (T - t));
            double exp3 = Math.exp(-this.a * (T + t - 2.0 * s));
            return coeff * (1.0 - exp1) - 0.5 * coeff * (exp2 - exp3);
        }
        double coeff = this.sigma * this.sigma / 2.0;
        return coeff * (t - s) * (2.0 * T - t - s);
    }

    public double B(double t, double T) {
        return this.a > Constants.QL_EPSILON ? 1.0 / this.a * (1.0 - Math.exp(-this.a * (T - t))) : T - t;
    }

    @Override
    public double x0() {
        return this.process.x0();
    }

    @Override
    public double drift(double t, double x) {
        double alpha_drift = this.sigma * this.sigma / (2.0 * this.a) * (1.0 - Math.exp(-2.0 * this.a * t));
        double shift = 1.0E-4;
        double f = this.h.currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency).rate();
        double fup = this.h.currentLink().forwardRate(t + 1.0E-4, t + 1.0E-4, Compounding.Continuous, Frequency.NoFrequency).rate();
        double f_prime = (fup - f) / 1.0E-4;
        return this.process.drift(t, x) + (alpha_drift += this.a * f + f_prime) - this.B(t, this.T_) * this.sigma * this.sigma;
    }

    @Override
    public double diffusion(double t, double x) {
        return this.process.diffusion(t, x);
    }

    @Override
    public double expectation(double t0, double x0, double dt) {
        return this.process.expectation(t0, x0, dt) + this.alpha(t0 + dt) - this.alpha(t0) * Math.exp(-this.a * dt) - this.M_T(t0, t0 + dt, this.T_);
    }

    @Override
    public double stdDeviation(double t0, double x0, double dt) {
        return this.process.stdDeviation(t0, x0, dt);
    }

    @Override
    public double variance(double t0, double x0, double dt) {
        return this.process.variance(t0, x0, dt);
    }
}

