/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.processes.EulerDiscretization;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.LocalVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.volatilities.BlackVarianceCurve;
import org.jquantlib.termstructures.volatilities.LocalConstantVol;
import org.jquantlib.termstructures.volatilities.LocalVolCurve;
import org.jquantlib.termstructures.volatilities.LocalVolSurface;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class GeneralizedBlackScholesProcess
extends StochasticProcess1D {
    private final Handle<? extends Quote> x0;
    private final Handle<YieldTermStructure> riskFreeRate;
    private final Handle<YieldTermStructure> dividendYield;
    private final Handle<BlackVolTermStructure> blackVolatility;
    private final RelinkableHandle<LocalVolTermStructure> localVolatility = new RelinkableHandle();
    private boolean updated;

    public GeneralizedBlackScholesProcess(Handle<? extends Quote> x0, Handle<YieldTermStructure> dividendTS, Handle<YieldTermStructure> riskFreeTS, Handle<BlackVolTermStructure> blackVolTS) {
        this(x0, dividendTS, riskFreeTS, blackVolTS, new EulerDiscretization());
    }

    public GeneralizedBlackScholesProcess(Handle<? extends Quote> x0, Handle<YieldTermStructure> dividendTS, Handle<YieldTermStructure> riskFreeTS, Handle<BlackVolTermStructure> blackVolTS, StochasticProcess1D.Discretization1D discretization) {
        super(discretization);
        this.x0 = x0;
        this.riskFreeRate = riskFreeTS;
        this.dividendYield = dividendTS;
        this.blackVolatility = blackVolTS;
        this.updated = false;
        this.x0.addObserver(this);
        this.riskFreeRate.addObserver(this);
        this.dividendYield.addObserver(this);
        this.blackVolatility.addObserver(this);
    }

    public final Handle<? extends Quote> stateVariable() {
        return this.x0;
    }

    public final Handle<YieldTermStructure> dividendYield() {
        return this.dividendYield;
    }

    public final Handle<YieldTermStructure> riskFreeRate() {
        return this.riskFreeRate;
    }

    public final Handle<BlackVolTermStructure> blackVolatility() {
        return this.blackVolatility;
    }

    public final Handle<LocalVolTermStructure> localVolatility() {
        if (!this.updated) {
            Class<?> klass = this.blackVolatility.currentLink().getClass();
            if (BlackConstantVol.class.isAssignableFrom(klass)) {
                BlackConstantVol constVol = (BlackConstantVol)this.blackVolatility.currentLink();
                this.localVolatility.linkTo(new LocalConstantVol(constVol.referenceDate(), constVol.blackVol(0.0, this.x0.currentLink().value()), constVol.dayCounter()));
                this.updated = true;
                return this.localVolatility;
            }
            if (BlackVarianceCurve.class.isAssignableFrom(klass)) {
                Handle<BlackVarianceCurve> volCurve = new Handle<BlackVarianceCurve>((BlackVarianceCurve)this.blackVolatility().currentLink());
                this.localVolatility.linkTo(new LocalVolCurve(volCurve));
                this.updated = true;
                return this.localVolatility;
            }
            if (LocalVolSurface.class.isAssignableFrom(klass)) {
                this.localVolatility.linkTo(new LocalVolSurface(this.blackVolatility, this.riskFreeRate, this.dividendYield, this.x0));
                this.updated = true;
                return this.localVolatility;
            }
            throw new LibraryException("unrecognized volatility curve");
        }
        return this.localVolatility;
    }

    @Override
    public double x0() {
        return this.x0.currentLink().value();
    }

    @Override
    public double drift(double t, double x) {
        double sigma = this.diffusion(t, x);
        double t1 = t + 1.0E-4;
        YieldTermStructure yts = this.riskFreeRate.currentLink();
        double r = yts.forwardRate(t, t1, Compounding.Continuous, Frequency.NoFrequency, true).rate();
        YieldTermStructure divTs = this.dividendYield.currentLink();
        double d = divTs.forwardRate(t, t1, Compounding.Continuous, Frequency.NoFrequency, true).rate();
        return r - d - 0.5 * sigma * sigma;
    }

    @Override
    public double diffusion(double t, double x) {
        double vol = this.localVolatility().currentLink().localVol(t, x, true);
        return vol;
    }

    @Override
    public final double apply(double x0, double dx) {
        double result = x0 * Math.exp(dx);
        return result;
    }

    @Override
    public final double time(Date d) {
        YieldTermStructure yts = this.riskFreeRate.currentLink();
        return yts.dayCounter().yearFraction(yts.referenceDate(), d);
    }

    @Override
    public final void update() {
        this.updated = false;
        super.update();
    }
}

