/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.processes.StochasticProcess1D;

@QualityAssurance(quality=QualityAssurance.Quality.Q2_RESEMBLANCE, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class EulerDiscretization
implements StochasticProcess.Discretization,
StochasticProcess1D.Discretization1D {
    @Override
    public Array driftDiscretization(StochasticProcess sp, double t0, Array x0, double dt) {
        return sp.drift(t0, x0).mulAssign(dt);
    }

    @Override
    public Matrix diffusionDiscretization(StochasticProcess sp, double t0, Array x0, double dt) {
        return sp.diffusion(t0, x0).mulAssign(Math.sqrt(dt));
    }

    @Override
    public Matrix covarianceDiscretization(StochasticProcess sp, double t0, Array x0, double dt) {
        Matrix sigma = sp.diffusion(t0, x0);
        return sigma.mul(sigma.transpose()).mulAssign(dt);
    }

    @Override
    public double driftDiscretization(StochasticProcess1D sp, double t0, double x0, double dt) {
        return sp.drift(t0, x0) * dt;
    }

    @Override
    public double diffusionDiscretization(StochasticProcess1D sp, double t0, double x0, double dt) {
        return sp.diffusion(t0, x0) * Math.sqrt(dt);
    }

    @Override
    public double varianceDiscretization(StochasticProcess1D sp, double t0, double x0, double dt) {
        double sigma = sp.diffusion(t0, x0);
        return sigma * sigma * dt;
    }
}

