/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.math.SampledCurve;
import org.jquantlib.methods.finitedifferences.StandardFiniteDifferenceModel;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDVanillaEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class FDEuropeanEngine
extends OneAssetOption.EngineImpl {
    private final FDVanillaEngine fdVanillaEngine;
    private SampledCurve prices;

    public FDEuropeanEngine(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        this.fdVanillaEngine = new FDVanillaEngine(process, timeSteps, gridPoints, timeDependent);
        this.prices = new SampledCurve(gridPoints);
        process.addObserver(this);
    }

    public FDEuropeanEngine(GeneralizedBlackScholesProcess stochProcess, int binomialSteps, int samples) {
        this(stochProcess, binomialSteps, samples, false);
    }

    @Override
    public void calculate() {
        this.fdVanillaEngine.setupArguments(this.arguments_);
        this.fdVanillaEngine.setGridLimits();
        this.fdVanillaEngine.initializeInitialCondition();
        this.fdVanillaEngine.initializeOperator();
        this.fdVanillaEngine.initializeBoundaryConditions();
        StandardFiniteDifferenceModel model = new StandardFiniteDifferenceModel(this.fdVanillaEngine.finiteDifferenceOperator, this.fdVanillaEngine.bcS);
        this.prices = new SampledCurve(this.fdVanillaEngine.intrinsicValues);
        this.prices.setValues(model.rollback(this.prices.values(), this.fdVanillaEngine.getResidualTime(), 0.0, this.fdVanillaEngine.timeSteps));
        OneAssetOption.ResultsImpl r = (OneAssetOption.ResultsImpl)this.results_;
        r.value = this.prices.valueAtCenter();
        Option.GreeksImpl greeks = r.greeks();
        greeks.delta = this.prices.firstDerivativeAtCenter();
        greeks.gamma = this.prices.secondDerivativeAtCenter();
        greeks.theta = greeks.blackScholesTheta(this.fdVanillaEngine.process, r.value, greeks.delta, greeks.gamma);
        r.additionalResults().put("priceCurve", this.prices);
    }
}

