/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.distributions.NormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.BlackFormula;
import org.jquantlib.pricingengines.vanilla.BaroneAdesiWhaleyApproximationEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class JuQuadraticApproximationEngine
extends VanillaOption.EngineImpl {
    private static final String NOT_AN_AMERICAN_OPTION = "not an American Option";
    private static final String NON_AMERICAN_EXERCISE_GIVEN = "non-American exercise given";
    private static final String PAYOFF_AT_EXPIRY_NOT_HANDLED = "payoff at expiry not handled";
    private static final String NON_STRIKE_PAYOFF_GIVEN = "non-striked payoff given";
    private static final String BLACK_SCHOLES_PROCESS_REQUIRED = "Black-Scholes process required";
    private static final String UNKNOWN_OPTION_TYPE = "unknown Option type";
    private static final String DIVIDING_BY_ZERO_INTEREST_RATE = "dividing by zero interst rate";
    private final GeneralizedBlackScholesProcess process;
    private final OneAssetOption.ArgumentsImpl a;
    private final OneAssetOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;

    public JuQuadraticApproximationEngine(GeneralizedBlackScholesProcess process) {
        this.a = (OneAssetOption.ArgumentsImpl)this.arguments_;
        this.r = (OneAssetOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        this.process = process;
        this.process.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(this.a.exercise.type() == Exercise.Type.American, NOT_AN_AMERICAN_OPTION);
        QL.require(this.a.exercise instanceof AmericanExercise, NON_AMERICAN_EXERCISE_GIVEN);
        AmericanExercise ex = (AmericanExercise)this.a.exercise;
        QL.require(!ex.payoffAtExpiry(), PAYOFF_AT_EXPIRY_NOT_HANDLED);
        QL.require(this.a.payoff instanceof StrikedTypePayoff, NON_STRIKE_PAYOFF_GIVEN);
        StrikedTypePayoff payoff = (StrikedTypePayoff)this.a.payoff;
        double variance = this.process.blackVolatility().currentLink().blackVariance(ex.lastDate(), payoff.strike());
        double dividendDiscount = this.process.dividendYield().currentLink().discount(ex.lastDate());
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(ex.lastDate());
        double spot = this.process.stateVariable().currentLink().value();
        QL.require(spot > 0.0, "negative or null underlying given");
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        if (dividendDiscount >= 1.0 && payoff.optionType() == Option.Type.Call) {
            this.r.value = black.value();
            this.greeks.delta = black.delta(spot);
            this.moreGreeks.deltaForward = black.deltaForward();
            this.moreGreeks.elasticity = black.elasticity(spot);
            this.greeks.gamma = black.gamma(spot);
            DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
            DayCounter divdc = this.process.dividendYield().currentLink().dayCounter();
            DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
            double t = rfdc.yearFraction(this.process.riskFreeRate().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.rho = black.rho(t);
            t = divdc.yearFraction(this.process.dividendYield().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.dividendRho = black.dividendRho(t);
            t = voldc.yearFraction(this.process.blackVolatility().currentLink().referenceDate(), this.a.exercise.lastDate());
            this.greeks.vega = black.vega(t);
            this.greeks.theta = black.theta(spot, t);
            this.moreGreeks.thetaPerDay = black.thetaPerDay(spot, t);
            this.moreGreeks.strikeSensitivity = black.strikeSensitivity();
            this.moreGreeks.itmCashProbability = black.itmCashProbability();
        } else {
            double phi;
            CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();
            NormalDistribution normalDist = new NormalDistribution();
            double tolerance = 1.0E-6;
            double Sk = BaroneAdesiWhaleyApproximationEngine.criticalPrice(payoff, riskFreeDiscount, dividendDiscount, variance, 1.0E-6);
            double forwardSk = Sk * dividendDiscount / riskFreeDiscount;
            double alpha = -2.0 * Math.log(riskFreeDiscount) / variance;
            double beta = 2.0 * Math.log(dividendDiscount / riskFreeDiscount) / variance;
            double h = 1.0 - riskFreeDiscount;
            switch (payoff.optionType()) {
                case Call: {
                    phi = 1.0;
                    break;
                }
                case Put: {
                    phi = -1.0;
                    break;
                }
                default: {
                    throw new LibraryException(UNKNOWN_OPTION_TYPE);
                }
            }
            QL.ensure(h != 0.0, DIVIDING_BY_ZERO_INTEREST_RATE);
            double temp_root = Math.sqrt((beta - 1.0) * (beta - 1.0) + 4.0 * alpha / h);
            double lambda = (-(beta - 1.0) + phi * temp_root) / 2.0;
            double lambda_prime = -phi * alpha / (h * h * temp_root);
            double black_Sk = BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forwardSk, Math.sqrt(variance)) * riskFreeDiscount;
            double hA = phi * (Sk - payoff.strike()) - black_Sk;
            double d1_Sk = (Math.log(forwardSk / payoff.strike()) + 0.5 * variance) / Math.sqrt(variance);
            double d2_Sk = d1_Sk - Math.sqrt(variance);
            double part1 = forwardSk * normalDist.op(d1_Sk) / (alpha * Math.sqrt(variance));
            double part2 = -phi * forwardSk * cumNormalDist.op(phi * d1_Sk) * Math.log(dividendDiscount) / Math.log(riskFreeDiscount);
            double part3 = phi * payoff.strike() * cumNormalDist.op(phi * d2_Sk);
            double V_E_h = part1 + part2 + part3;
            double b = (1.0 - h) * alpha * lambda_prime / (2.0 * (2.0 * lambda + beta - 1.0));
            double c = -((1.0 - h) * alpha / (2.0 * lambda + beta - 1.0)) * (V_E_h / hA + 1.0 / h + lambda_prime / (2.0 * lambda + beta - 1.0));
            double temp_spot_ratio = Math.log(spot / Sk);
            double chi = temp_spot_ratio * (b * temp_spot_ratio + c);
            this.r.value = phi * (Sk - spot) > 0.0 ? black.value() + hA * Math.pow(spot / Sk, lambda) / (1.0 - chi) : phi * (spot - payoff.strike());
            double temp_chi_prime = 2.0 * b / spot * Math.log(spot / Sk);
            double chi_prime = temp_chi_prime + c / spot;
            double chi_double_prime = 2.0 * b / (spot * spot) - temp_chi_prime / spot - c / (spot * spot);
            this.greeks.delta = phi * dividendDiscount * cumNormalDist.op(phi * d1_Sk) + (lambda / (spot * (1.0 - chi)) + chi_prime / ((1.0 - chi) * (1.0 - chi))) * (phi * (Sk - payoff.strike()) - black_Sk) * Math.pow(spot / Sk, lambda);
            this.greeks.gamma = phi * dividendDiscount * normalDist.op(phi * d1_Sk) / (spot * Math.sqrt(variance)) + (2.0 * lambda * chi_prime / (spot * (1.0 - chi) * (1.0 - chi)) + 2.0 * chi_prime * chi_prime / ((1.0 - chi) * (1.0 - chi) * (1.0 - chi)) + chi_double_prime / ((1.0 - chi) * (1.0 - chi)) + lambda * (1.0 - lambda) / (spot * spot * (1.0 - chi))) * (phi * (Sk - payoff.strike()) - black_Sk) * Math.pow(spot / Sk, lambda);
        }
    }
}

