/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.QL;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.SegmentIntegral;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class IntegralEngine
extends OneAssetOption.EngineImpl {
    private static final String NOT_AN_AMERICAN_OPTION = "not an American Option";
    private static final String NON_STRIKED_PAYOFF_GIVEN = "non-striked payoff given";
    private static final String BLACK_SCHOLES_PROCESS_REQUIRED = "Black-Scholes process required";
    private final GeneralizedBlackScholesProcess process;
    private final Option.ArgumentsImpl a;
    private final Instrument.ResultsImpl r;

    public IntegralEngine(GeneralizedBlackScholesProcess process) {
        this.a = (Option.ArgumentsImpl)this.arguments_;
        this.r = (Instrument.ResultsImpl)this.results_;
        this.process = process;
        this.process.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(this.a.exercise.type() == Exercise.Type.European, NOT_AN_AMERICAN_OPTION);
        QL.require(this.a.payoff instanceof StrikedTypePayoff, NON_STRIKED_PAYOFF_GIVEN);
        StrikedTypePayoff payoff = (StrikedTypePayoff)this.a.payoff;
        double variance = this.process.blackVolatility().currentLink().blackVariance(this.a.exercise.lastDate(), payoff.strike());
        double dividendDiscount = this.process.dividendYield().currentLink().discount(this.a.exercise.lastDate());
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(this.a.exercise.lastDate());
        double drift = Math.log(dividendDiscount / riskFreeDiscount) - 0.5 * variance;
        Integrand f = new Integrand(this.a.payoff, this.process.stateVariable().currentLink().value(), drift, variance);
        SegmentIntegral integrator = new SegmentIntegral(5000);
        double infinity = 10.0 * Math.sqrt(variance);
        this.r.value = this.process.riskFreeRate().currentLink().discount(this.a.exercise.lastDate()) / Math.sqrt(Math.PI * 2 * variance) * integrator.op(f, drift - infinity, drift + infinity);
    }

    private static class Integrand
    implements Ops.DoubleOp {
        private final Payoff payoff;
        private final double s0;
        private final double drift;
        private final double variance;

        public Integrand(Payoff payoff, double s0, double drift, double variance) {
            this.payoff = payoff;
            this.s0 = s0;
            this.drift = drift;
            this.variance = variance;
        }

        @Override
        public double op(double x) {
            double temp = this.s0 * Math.exp(x);
            double result = this.payoff.get(temp);
            return result * Math.exp(-(x - this.drift) * (x - this.drift) / (2.0 * this.variance));
        }
    }
}

