/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.QL;
import org.jquantlib.cashflow.CashFlow;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.DividendVanillaOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class AnalyticDividendEuropeanEngine
extends DividendVanillaOption.EngineImpl {
    private final GeneralizedBlackScholesProcess process;
    private final DividendVanillaOption.ArgumentsImpl a;
    private final DividendVanillaOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;

    public AnalyticDividendEuropeanEngine(GeneralizedBlackScholesProcess process) {
        this.a = (DividendVanillaOption.ArgumentsImpl)this.arguments_;
        this.r = (DividendVanillaOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        this.process = process;
        this.process.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(this.a.exercise.type() == Exercise.Type.European, "not an European option");
        StrikedTypePayoff payoff = (StrikedTypePayoff)this.a.payoff;
        QL.require(payoff != null, "non-striked payoff given");
        Date settlementDate = this.process.riskFreeRate().currentLink().referenceDate();
        double riskless = 0.0;
        for (int i = 0; i < this.a.cashFlow.size(); ++i) {
            CashFlow cashflow = this.a.cashFlow.get(i);
            if (!cashflow.date().gt(settlementDate)) continue;
            riskless += cashflow.amount() * this.process.riskFreeRate().currentLink().discount(cashflow.date());
        }
        double spot = this.process.stateVariable().currentLink().value() - riskless;
        QL.require(spot > 0.0, "negative or null underlying after subtracting dividends");
        double dividendDiscount = this.process.dividendYield().currentLink().discount(this.a.exercise.lastDate());
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(this.a.exercise.lastDate());
        double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
        double variance = this.process.blackVolatility().currentLink().blackVariance(this.a.exercise.lastDate(), payoff.strike());
        BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
        this.r.value = black.value();
        this.greeks.delta = black.delta(spot);
        this.greeks.gamma = black.gamma(spot);
        DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
        DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
        double t = voldc.yearFraction(this.process.blackVolatility().currentLink().referenceDate(), this.a.exercise.lastDate());
        this.greeks.vega = black.vega(t);
        double delta_theta = 0.0;
        double delta_rho = 0.0;
        for (int i = 0; i < this.a.cashFlow.size(); ++i) {
            CashFlow cashflow = this.a.cashFlow.get(i);
            Date d = cashflow.date();
            if (!d.gt(settlementDate)) continue;
            delta_theta -= cashflow.amount() * this.process.riskFreeRate().currentLink().zeroRate(d, rfdc, Compounding.Continuous, Frequency.Annual).rate() * this.process.riskFreeRate().currentLink().discount(d);
            delta_rho += cashflow.amount() * this.process.time(d) * this.process.riskFreeRate().currentLink().discount(t);
        }
        t = this.process.time(this.a.exercise.lastDate());
        try {
            this.greeks.theta = black.theta(spot, t) + delta_theta * black.delta(spot);
        }
        catch (ArithmeticException e) {
            this.greeks.theta = Double.MAX_VALUE;
        }
        this.greeks.rho = black.rho(t) + delta_rho * black.delta(spot);
    }
}

