/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.asian;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.AverageType;
import org.jquantlib.instruments.ContinuousAveragingAsianOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;

public class AnalyticContinuousGeometricAveragePriceAsianEngine
extends ContinuousAveragingAsianOption.EngineImpl {
    private final GeneralizedBlackScholesProcess process;
    private final ContinuousAveragingAsianOption.ArgumentsImpl a;
    private final ContinuousAveragingAsianOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;

    public AnalyticContinuousGeometricAveragePriceAsianEngine(GeneralizedBlackScholesProcess process) {
        this.process = process;
        this.a = (ContinuousAveragingAsianOption.ArgumentsImpl)this.arguments_;
        this.r = (ContinuousAveragingAsianOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        process.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(this.a.averageType == AverageType.Geometric, "not a geometric average option");
        QL.require(this.a.exercise.type() == Exercise.Type.European, "not an European Option");
        Date exercise = this.a.exercise.lastDate();
        QL.require(this.a.payoff instanceof PlainVanillaPayoff, "non-plain payoff given");
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)((ContinuousAveragingAsianOption.ArgumentsImpl)this.arguments_).payoff;
        double volatility = this.process.blackVolatility().currentLink().blackVol(exercise, payoff.strike());
        double variance = this.process.blackVolatility().currentLink().blackVariance(exercise, payoff.strike());
        double riskFreeDiscount = this.process.riskFreeRate().currentLink().discount(exercise);
        DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
        DayCounter divdc = this.process.dividendYield().currentLink().dayCounter();
        DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
        double dividendYield = 0.5 * (this.process.riskFreeRate().currentLink().zeroRate(exercise, rfdc, Compounding.Continuous, Frequency.NoFrequency).rate() + this.process.dividendYield().currentLink().zeroRate(exercise, divdc, Compounding.Continuous, Frequency.NoFrequency).rate() + volatility * volatility / 6.0);
        double t_q = divdc.yearFraction(this.process.dividendYield().currentLink().referenceDate(), exercise);
        double dividendDiscount = Math.exp(-dividendYield * t_q);
        double spot = this.process.stateVariable().currentLink().value();
        QL.require(spot > 0.0, "negative or null underlying given");
        double forward = spot * dividendDiscount / riskFreeDiscount;
        BlackCalculator black = new BlackCalculator(payoff, forward, Math.sqrt(variance / 3.0), riskFreeDiscount);
        this.r.value = black.value();
        this.greeks.delta = black.delta(spot);
        this.greeks.gamma = black.gamma(spot);
        this.greeks.dividendRho = black.dividendRho(t_q) / 2.0;
        double t_r = rfdc.yearFraction(this.process.riskFreeRate().currentLink().referenceDate(), this.a.exercise.lastDate());
        this.greeks.rho = black.rho(t_r) + 0.5 * black.dividendRho(t_q);
        double t_v = voldc.yearFraction(this.process.blackVolatility().currentLink().referenceDate(), this.a.exercise.lastDate());
        this.greeks.vega = black.vega(t_v) / Math.sqrt(3.0) + black.dividendRho(t_q) * volatility / 6.0;
        try {
            this.greeks.theta = black.theta(spot, t_v);
        }
        catch (ArithmeticException e) {
            this.greeks.theta = Double.MAX_VALUE;
        }
    }
}

