/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import org.jquantlib.QL;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.lang.annotation.DiscountFactor;
import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Real;
import org.jquantlib.lang.annotation.StdDev;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.distributions.Derivative;
import org.jquantlib.math.solvers1D.NewtonSafe;

public class BlackFormula {
    public static double blackFormula(Option.Type optionType, @Real double strike, @Real double forward, @StdDev double stddev) {
        return BlackFormula.blackFormula(optionType, strike, forward, stddev, 1.0, 0.0);
    }

    public static double blackFormula(Option.Type optionType, @Real double strike, @Real double forward, @StdDev double stddev, @DiscountFactor double discount) {
        return BlackFormula.blackFormula(optionType, strike, forward, stddev, discount, 0.0);
    }

    public static double blackFormula(Option.Type optionType, @Real double strike, @Real double forward, @StdDev double stddev, @DiscountFactor double discount, @Real double displacement) {
        QL.require(strike >= 0.0, "strike must be non-negative");
        QL.require(forward > 0.0, "forward must be positive");
        QL.require(stddev >= 0.0, "stddev must be non-negative");
        QL.require(discount > 0.0, "discount must be positive");
        QL.require(displacement >= 0.0, "displacement must be non-negative");
        forward += displacement;
        strike += displacement;
        if (stddev == 0.0) {
            return Math.max((forward - strike) * (double)optionType.toInteger(), 0.0) * discount;
        }
        if (strike == 0.0) {
            return optionType == Option.Type.Call ? forward * discount : 0.0;
        }
        double d1 = Math.log(forward / strike) / stddev + 0.5 * stddev;
        double d2 = d1 - stddev;
        CumulativeNormalDistribution phi = new CumulativeNormalDistribution();
        double result = discount * (double)optionType.toInteger() * (forward * phi.op((double)optionType.toInteger() * d1) - strike * phi.op((double)optionType.toInteger() * d2));
        if (result >= 0.0) {
            return result;
        }
        throw new ArithmeticException("a negative value was calculated");
    }

    public static double blackFormula(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @StdDev double stddev) {
        return BlackFormula.blackFormula(payoff, strike, forward, stddev, 1.0, 0.0);
    }

    public static double blackFormula(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @StdDev double stddev, @DiscountFactor double discount) {
        return BlackFormula.blackFormula(payoff, strike, forward, stddev, discount, 0.0);
    }

    public static double blackFormula(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @StdDev double stddev, @DiscountFactor double discount, @Real double displacement) {
        return BlackFormula.blackFormula(payoff.optionType(), payoff.strike(), forward, stddev, discount, displacement);
    }

    public static double blackFormulaImpliedStdDevApproximation(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice) {
        return BlackFormula.blackFormulaImpliedStdDevApproximation(optionType, strike, forward, blackPrice, 1.0, 0.0);
    }

    public static double blackFormulaImpliedStdDevApproximation(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount) {
        return BlackFormula.blackFormulaImpliedStdDevApproximation(optionType, strike, forward, blackPrice, discount, 0.0);
    }

    public static double blackFormulaImpliedStdDevApproximation(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double displacement) {
        double stddev;
        QL.require(strike >= 0.0, "strike must be non-negative");
        QL.require(forward > 0.0, "forward must be positive");
        QL.require(displacement >= 0.0, "displacement must be non-negative");
        QL.require(blackPrice >= 0.0, "blackPrice must be non-negative");
        QL.require(discount > 0.0, "discount must be positive");
        if (Closeness.isClose(strike += displacement, forward += displacement)) {
            stddev = blackPrice / discount * Math.sqrt(Math.PI * 2) / forward;
        } else {
            double moneynessDelta_PI;
            double moneynessDelta = (double)optionType.toInteger() * (forward - strike);
            double moneynessDelta_2 = moneynessDelta / 2.0;
            double temp = blackPrice / discount - moneynessDelta_2;
            double temp2 = temp * temp - (moneynessDelta_PI = moneynessDelta * moneynessDelta / Math.PI);
            if (temp2 < 0.0) {
                temp2 = 0.0;
            }
            temp2 = Math.sqrt(temp2);
            temp += temp2;
            stddev = (temp *= Math.sqrt(Math.PI * 2)) / (forward + strike);
        }
        if (stddev >= 0.0) {
            return stddev;
        }
        throw new ArithmeticException("a negative value was calculated");
    }

    public static double blackFormulaImpliedStdDevApproximation(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice) {
        return BlackFormula.blackFormulaImpliedStdDevApproximation(payoff, strike, forward, blackPrice, 1.0, 0.0);
    }

    public static double blackFormulaImpliedStdDevApproximation(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount) {
        return BlackFormula.blackFormulaImpliedStdDevApproximation(payoff, strike, forward, blackPrice, discount, 0.0);
    }

    public static double blackFormulaImpliedStdDevApproximation(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double displacement) {
        return BlackFormula.blackFormulaImpliedStdDevApproximation(payoff.optionType(), payoff.strike(), forward, blackPrice, discount, displacement);
    }

    public static double blackFormulaImpliedStdDev(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice) {
        return BlackFormula.blackFormulaImpliedStdDev(optionType, strike, forward, blackPrice, 1.0, Double.NaN, 1.0E-6, 0.0);
    }

    public static double blackFormulaImpliedStdDev(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount) {
        return BlackFormula.blackFormulaImpliedStdDev(optionType, strike, forward, blackPrice, discount, Double.NaN, 1.0E-6, 0.0);
    }

    public static double blackFormulaImpliedStdDev(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double guess) {
        return BlackFormula.blackFormulaImpliedStdDev(optionType, strike, forward, blackPrice, discount, guess, 1.0E-6, 0.0);
    }

    public static double blackFormulaImpliedStdDev(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double guess, @Real double accuracy) {
        return BlackFormula.blackFormulaImpliedStdDev(optionType, strike, forward, blackPrice, discount, guess, accuracy, 0.0);
    }

    public static double blackFormulaImpliedStdDev(Option.Type optionType, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double guess, @Real double accuracy, @Real double displacement) {
        int maxIterations = 100;
        QL.require(strike >= 0.0, "strike must be non-negative");
        QL.require(forward > 0.0, "forward must be positive");
        QL.require(displacement >= 0.0, "displacement must be non-negative");
        QL.require(blackPrice >= 0.0, "blackPrice must be non-negative");
        QL.require(discount > 0.0, "discount must be positive");
        strike += displacement;
        forward += displacement;
        if (Double.isNaN(guess)) {
            guess = BlackFormula.blackFormulaImpliedStdDevApproximation(optionType, strike, forward, blackPrice, discount, displacement);
        } else if (guess < 0.0) {
            throw new IllegalArgumentException("stddev guess (" + guess + ") must be non-negative");
        }
        BlackImpliedStdDevHelper f = new BlackImpliedStdDevHelper(optionType, strike, forward, blackPrice / discount);
        NewtonSafe solver = new NewtonSafe();
        solver.setMaxEvaluations(100);
        double minSdtDev = 0.0;
        double maxstddev = 3.0;
        double stddev = solver.solve(f, accuracy, guess, 0.0, 3.0);
        if (stddev >= 0.0) {
            return stddev;
        }
        throw new ArithmeticException("a negative value was calculated");
    }

    public static double blackFormulaImpliedStdDev(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice) {
        return BlackFormula.blackFormulaImpliedStdDev(payoff, strike, forward, blackPrice, 1.0, Double.NaN, 1.0E-6, 0.0);
    }

    public static double blackFormulaImpliedStdDev(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount) {
        return BlackFormula.blackFormulaImpliedStdDev(payoff, strike, forward, blackPrice, discount, Double.NaN, 1.0E-6, 0.0);
    }

    public static double blackFormulaImpliedStdDev(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double guess) {
        return BlackFormula.blackFormulaImpliedStdDev(payoff, strike, forward, blackPrice, discount, guess, 1.0E-6, 0.0);
    }

    public static double blackFormulaImpliedStdDev(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double guess, @Real double accuracy) {
        return BlackFormula.blackFormulaImpliedStdDev(payoff.optionType(), strike, forward, blackPrice, discount, guess, accuracy, 0.0);
    }

    public static double blackFormulaImpliedStdDev(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @Real double blackPrice, @DiscountFactor double discount, @Real double guess, @Real double accuracy, @Real double displacement) {
        return BlackFormula.blackFormulaImpliedStdDev(payoff.optionType(), strike, forward, blackPrice, discount, guess, accuracy, displacement);
    }

    public static double blackFormulaCashItmProbability(Option.Type optionType, @Real double strike, @Real double forward, @StdDev double stddev) {
        return BlackFormula.blackFormulaCashItmProbability(optionType, strike, forward, stddev, 0.0);
    }

    public static double blackFormulaCashItmProbability(Option.Type optionType, @Real double strike, @Real double forward, @StdDev double stddev, @Real double displacement) {
        if (stddev == 0.0) {
            return forward * (double)optionType.toInteger() > strike * (double)optionType.toInteger() ? 1.0 : 0.0;
        }
        if (strike == 0.0) {
            return optionType == Option.Type.Call ? 1.0 : 0.0;
        }
        double d1 = Math.log((forward + displacement) / (strike + displacement)) / stddev + 0.5 * stddev;
        double d2 = d1 - stddev;
        CumulativeNormalDistribution phi = new CumulativeNormalDistribution();
        return phi.op((double)optionType.toInteger() * d2);
    }

    public static double blackFormulaCashItmProbability(PlainVanillaPayoff payoff, @Real double strike, @Real double forward, @StdDev double stddev, @Real double displacement) {
        return BlackFormula.blackFormulaCashItmProbability(payoff.optionType(), strike, forward, stddev, displacement);
    }

    public static double blackFormulaStdDevDerivative(@Real double strike, @Real double forward, @StdDev double stddev) {
        return BlackFormula.blackFormulaStdDevDerivative(strike, forward, stddev, 1.0, 0.0);
    }

    public static double blackFormulaStdDevDerivative(@Real double strike, @Real double forward, @StdDev double stddev, @DiscountFactor double discount) {
        return BlackFormula.blackFormulaStdDevDerivative(strike, forward, stddev, discount, 0.0);
    }

    public static double blackFormulaStdDevDerivative(@Real double strike, @Real double forward, @StdDev double stddev, @DiscountFactor double discount, @Real double displacement) {
        QL.require(strike >= 0.0, "strike must be non-negative");
        QL.require(forward > 0.0, "forward must be positive");
        QL.require(stddev >= 0.0, "blackPrice must be non-negative");
        QL.require(discount > 0.0, "discount must be positive");
        QL.require(displacement >= 0.0, "displacement must be non-negative");
        double d1 = Math.log((forward += displacement) / (strike += displacement)) / stddev + 0.5 * stddev;
        CumulativeNormalDistribution cdf = new CumulativeNormalDistribution();
        return discount * forward * cdf.derivative(d1);
    }

    public static double blackFormulastddevDerivative(PlainVanillaPayoff payoff, @Real double forward, @StdDev double stddev) {
        return BlackFormula.blackFormulaStdDevDerivative(payoff, forward, stddev, 1.0, 0.0);
    }

    public static double blackFormulastddevDerivative(PlainVanillaPayoff payoff, @Real double forward, @StdDev double stddev, @DiscountFactor double discount) {
        return BlackFormula.blackFormulaStdDevDerivative(payoff, forward, stddev, discount, 0.0);
    }

    public static double blackFormulaStdDevDerivative(PlainVanillaPayoff payoff, @Real double forward, @StdDev double stddev, @DiscountFactor double discount, @Real double displacement) {
        return BlackFormula.blackFormulaStdDevDerivative(payoff.strike(), forward, stddev, discount, displacement);
    }

    public static double bachelierBlackFormula(PlainVanillaPayoff payoff, @Real double forward, @StdDev double stddev, @Real double discount) {
        return BlackFormula.bachelierBlackFormula(payoff.optionType(), payoff.strike(), forward, stddev, discount);
    }

    public static double bachelierBlackFormula(Option.Type optionType, @Real double strike, @Real double forward, @StdDev double stddev, @DiscountFactor double discount) {
        QL.require(stddev >= 0.0, "blackPrice must be non-negative");
        QL.require(discount > 0.0, "discount must be positive");
        double d = (forward - strike) * (double)optionType.ordinal();
        double h = d / stddev;
        if (stddev == 0.0) {
            return discount * Math.max(d, 0.0);
        }
        CumulativeNormalDistribution phi = new CumulativeNormalDistribution();
        double result = discount * stddev * phi.derivative(h) + d * phi.op(h);
        if (result >= 0.0) {
            return result;
        }
        throw new ArithmeticException("negative value");
    }

    public static double bachelierBlackFormula(Option.Type optionType, @Real double strike, @Real double forward, @StdDev double stddev) {
        return BlackFormula.bachelierBlackFormula(optionType, strike, forward, stddev, 1.0);
    }

    public static double bachelierBlackFormula(PlainVanillaPayoff payoff, @Real double forward, @StdDev double stddev) {
        return BlackFormula.bachelierBlackFormula(payoff, forward, stddev, 1.0);
    }

    private static class BlackImpliedStdDevHelper
    implements Derivative {
        private final double halfOptionType_;
        private final double signedStrike_;
        private final double signedForward_;
        private final double undiscountedBlackPrice_;
        private final double signedMoneyness_;
        private final CumulativeNormalDistribution N_;

        public BlackImpliedStdDevHelper(Option.Type optionType, double strike, double forward, double undiscountedBlackPrice) {
            this(optionType, strike, forward, undiscountedBlackPrice, 0.0);
        }

        public BlackImpliedStdDevHelper(Option.Type optionType, double strike, double forward, double undiscountedBlackPrice, double displacement) {
            QL.require(strike >= 0.0, "strike must be non-negative");
            QL.require(forward > 0.0, "forward must be positive");
            QL.require(displacement >= 0.0, "displacement must be non-negative");
            QL.require(undiscountedBlackPrice >= 0.0, "undiscounted Black price must be non-negative");
            this.halfOptionType_ = 0.5 * (double)optionType.toInteger();
            this.signedStrike_ = (double)optionType.toInteger() * (strike + displacement);
            this.signedForward_ = (double)optionType.toInteger() * (forward + displacement);
            this.undiscountedBlackPrice_ = undiscountedBlackPrice;
            this.signedMoneyness_ = (double)optionType.toInteger() * Math.log((forward + displacement) / (strike + displacement));
            this.N_ = new CumulativeNormalDistribution();
        }

        @Override
        public double op(@NonNegative double stddev) {
            QL.require(stddev >= 0.0, "stddev must be non-negative");
            if (stddev == 0.0) {
                return Math.max(this.signedForward_ - this.signedStrike_, 0.0) - this.undiscountedBlackPrice_;
            }
            double temp = this.halfOptionType_ * stddev;
            double d = this.signedMoneyness_ / stddev;
            double signedD1 = d + temp;
            double signedD2 = d - temp;
            double result = this.signedForward_ * this.N_.op(signedD1) - this.signedStrike_ * this.N_.op(signedD2);
            return Math.max(0.0, result) - this.undiscountedBlackPrice_;
        }

        @Override
        public double derivative(@NonNegative double stddev) {
            QL.require(stddev >= 0.0, "stddev must be non-negative");
            double signedD1 = this.signedMoneyness_ / stddev + this.halfOptionType_ * stddev;
            return this.signedForward_ * this.N_.derivative(signedD1);
        }
    }
}

