/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.equity;

import org.jquantlib.math.optimization.BoundaryConstraint;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;
import org.jquantlib.model.equity.HestonModel;
import org.jquantlib.processes.HestonProcess;

public class BatesDoubleExpModel
extends HestonModel {
    public BatesDoubleExpModel(HestonProcess process) {
        this(process, 0.1, 0.1, 0.1, 0.5);
    }

    public BatesDoubleExpModel(HestonProcess process, double lambda, double nuUp, double nuDown, double p) {
        super(process);
        this.arguments_.set(5, new ConstantParameter(p, new BoundaryConstraint(0.0, 1.0)));
        this.arguments_.set(6, new ConstantParameter(nuDown, new PositiveConstraint()));
        this.arguments_.set(7, new ConstantParameter(nuUp, new PositiveConstraint()));
        this.arguments_.set(8, new ConstantParameter(lambda, new PositiveConstraint()));
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public double p() {
        return ((Parameter)this.arguments_.get(5)).get(0.0);
    }

    public double nuDown() {
        return ((Parameter)this.arguments_.get(6)).get(0.0);
    }

    public double nuUp() {
        return ((Parameter)this.arguments_.get(7)).get(0.0);
    }

    public double lambda() {
        return ((Parameter)this.arguments_.get(8)).get(0.0);
    }

    public static class BatesDoubleExpDetJumpModel
    extends BatesDoubleExpModel {
        public BatesDoubleExpDetJumpModel(HestonProcess process, double lambda, double nuUp, double nuDown, double p, double kappaLambda, double thetaLambda) {
            super(process);
            this.arguments_.set(9, new ConstantParameter(kappaLambda, new PositiveConstraint()));
            this.arguments_.set(10, new ConstantParameter(thetaLambda, new PositiveConstraint()));
        }

        public BatesDoubleExpDetJumpModel(HestonProcess process) {
            this(process, 0.1, 0.1, 0.1, 0.5, 1.0, 0.1);
        }

        public double kappaLambda() {
            return ((Parameter)this.arguments_.get(9)).get(0.0);
        }

        public double thetaLambda() {
            return ((Parameter)this.arguments_.get(10)).get(0.0);
        }
    }
}

