/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.montecarlo;

import java.util.Arrays;
import org.jquantlib.time.TimeGrid;

public class BrownianBridge {
    private final int size_;
    private final double[] t_;
    private final double[] sqrtdt_;
    private final int[] bridgeIndex_;
    private final int[] leftIndex_;
    private final int[] rightIndex_;
    private final double[] leftWeight_;
    private final double[] rightWeight_;
    private final double[] stdDev_;

    public BrownianBridge(int steps) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.size_ = steps;
        this.t_ = new double[this.size_];
        this.sqrtdt_ = new double[this.size_];
        this.bridgeIndex_ = new int[this.size_];
        this.leftIndex_ = new int[this.size_];
        this.rightIndex_ = new int[this.size_];
        this.leftWeight_ = new double[this.size_];
        this.rightWeight_ = new double[this.size_];
        this.stdDev_ = new double[this.size_];
        for (int i = 0; i < this.size_; ++i) {
            this.t_[i] = i + 1;
        }
        this.initialize();
    }

    public BrownianBridge(double[] times) {
        this.size_ = times.length;
        this.t_ = Arrays.copyOfRange(times, 0, this.size_);
        this.sqrtdt_ = new double[this.size_];
        this.bridgeIndex_ = new int[this.size_];
        this.leftIndex_ = new int[this.size_];
        this.rightIndex_ = new int[this.size_];
        this.leftWeight_ = new double[this.size_];
        this.rightWeight_ = new double[this.size_];
        this.stdDev_ = new double[this.size_];
        this.initialize();
    }

    public BrownianBridge(TimeGrid timeGrid) {
        this.size_ = timeGrid.size() - 1;
        this.t_ = new double[this.size_];
        this.sqrtdt_ = new double[this.size_];
        this.bridgeIndex_ = new int[this.size_];
        this.leftIndex_ = new int[this.size_];
        this.rightIndex_ = new int[this.size_];
        this.leftWeight_ = new double[this.size_];
        this.rightWeight_ = new double[this.size_];
        this.stdDev_ = new double[this.size_];
        for (int i = 0; i < this.size_; ++i) {
            this.t_[i] = timeGrid.get(i + 1);
        }
        this.initialize();
    }

    private void initialize() {
        this.sqrtdt_[0] = Math.sqrt(this.t_[0]);
        for (int i = 1; i < this.size_; ++i) {
            this.sqrtdt_[i] = Math.sqrt(this.t_[i] - this.t_[i - 1]);
        }
        int[] map = new int[this.size_];
        Arrays.fill(map, 0);
        map[this.size_ - 1] = 1;
        this.bridgeIndex_[0] = this.size_ - 1;
        this.stdDev_[0] = Math.sqrt(this.t_[this.size_ - 1]);
        this.rightWeight_[0] = 0.0;
        this.leftWeight_[0] = 0.0;
        int j = 0;
        for (int i = 1; i < this.size_; ++i) {
            while (map[j] != 0) {
                ++j;
            }
            int k = j;
            while (map[k] == 0) {
                ++k;
            }
            int l = j + (k - 1 - j >> 1);
            map[l] = i;
            this.bridgeIndex_[i] = l;
            this.leftIndex_[i] = j;
            this.rightIndex_[i] = k;
            if (j != 0) {
                this.leftWeight_[i] = (this.t_[k] - this.t_[l]) / (this.t_[k] - this.t_[j - 1]);
                this.rightWeight_[i] = (this.t_[l] - this.t_[j - 1]) / (this.t_[k] - this.t_[j - 1]);
                this.stdDev_[i] = Math.sqrt((this.t_[l] - this.t_[j - 1]) * (this.t_[k] - this.t_[l]) / (this.t_[k] - this.t_[j - 1]));
            } else {
                this.leftWeight_[i] = (this.t_[k] - this.t_[l]) / this.t_[k];
                this.rightWeight_[i] = this.t_[l] / this.t_[k];
                this.stdDev_[i] = Math.sqrt(this.t_[l] * (this.t_[k] - this.t_[l]) / this.t_[k]);
            }
            j = k + 1;
            if (j < this.size_) continue;
            j = 0;
        }
    }

    public int size() {
        return this.size_;
    }

    public final double[] times() {
        return this.t_;
    }

    public void transform(double[] input, double[] output) {
        int i;
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("invalid sequence");
        }
        if (input.length != this.size_) {
            throw new IllegalArgumentException("incompatible sequence size");
        }
        output[this.size_ - 1] = this.stdDev_[0] * input[0];
        for (i = 1; i < this.size_; ++i) {
            int j = this.leftIndex_[i];
            int k = this.rightIndex_[i];
            int l = this.bridgeIndex_[i];
            output[l] = j != 0 ? this.leftWeight_[i] * output[j - 1] + this.rightWeight_[i] * output[k] + this.stdDev_[i] * input[i] : this.rightWeight_[i] * output[k] + this.stdDev_[i] * input[i];
        }
        for (i = this.size_ - 1; i >= 1; --i) {
            int n = i;
            output[n] = output[n] - output[i - 1];
            int n2 = i;
            output[n2] = output[n2] / this.sqrtdt_[i];
        }
        output[0] = output[0] / this.sqrtdt_[0];
    }
}

