/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import java.util.Vector;
import org.jquantlib.methods.lattices.Tree;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.time.TimeGrid;

public class TrinomialTree
extends Tree {
    public static final Tree.Branches branches = Tree.Branches.TRINOMIAL;
    protected Vector<Branching> branchings_ = new Vector();
    protected double x0_;
    protected Vector<Double> dx_ = new Vector();
    protected TimeGrid timeGrid_;

    public TrinomialTree(StochasticProcess1D process, TimeGrid timeGrid) {
        this(process, timeGrid, false);
    }

    public TrinomialTree(StochasticProcess1D process, TimeGrid timeGrid, boolean isPositive) {
        super(timeGrid.size());
        this.dx_.add(new Double(1.0));
        this.dx_.add(new Double(0.0));
        this.timeGrid_ = timeGrid;
        this.x0_ = process.x0();
        int nTimeSteps = timeGrid.size() - 1;
        Integer jMin = 0;
        Integer jMax = 0;
        for (int i = 0; i < nTimeSteps; ++i) {
            double t = timeGrid.at(i);
            double dt = timeGrid.dt(i);
            double v2 = process.variance(t, 0.0, dt);
            double v = Math.sqrt(v2);
            this.dx_.add(v * Math.sqrt(3.0));
            Branching branching = new Branching();
            for (int j = jMin.intValue(); j <= jMax; ++j) {
                double x = this.x0_ + (double)j * this.dx_.get(i);
                double m = process.expectation(t, x, dt);
                int temp = (int)Math.floor((m - this.x0_) / this.dx_.get(i + 1) + 0.5);
                if (isPositive) {
                    while (this.x0_ + (double)(temp - 1) * this.dx_.get(i + 1) <= 0.0) {
                        ++temp;
                    }
                }
                double e = m - (this.x0_ + (double)temp * this.dx_.get(i + 1));
                double e2 = e * e;
                double e3 = e * Math.sqrt(3.0);
                double p1 = (1.0 + e2 / v2 - e3 / v) / 6.0;
                double p2 = (2.0 - e2 / v2) / 3.0;
                double p3 = (1.0 + e2 / v2 + e3 / v) / 6.0;
                branching.add(temp, p1, p2, p3);
            }
            this.branchings_.add(branching);
            jMin = branching.jMin();
            jMax = branching.jMax();
        }
    }

    public double dx(int i) {
        return this.dx_.get(i);
    }

    public TimeGrid timeGrid() {
        return this.timeGrid_;
    }

    @Override
    public int size(int i) {
        return i == 0 ? 1 : this.branchings_.get(i - 1).size();
    }

    @Override
    public double underlying(int i, int index) {
        if (i == 0) {
            return this.x0_;
        }
        return this.x0_ + ((double)this.branchings_.get(i - 1).jMin() + (double)index) * this.dx(i);
    }

    @Override
    public int descendant(int i, int index, int branch) {
        return this.branchings_.get(i).descendant(index, branch);
    }

    @Override
    public double probability(int i, int index, int branch) {
        return this.branchings_.get(i).probability(index, branch);
    }

    private static class Branching {
        private final Vector<Integer> k_ = new Vector();
        private final Vector<Vector<Double>> probs_ = new Vector(3);
        private int kMin_ = Integer.MAX_VALUE;
        private int jMin_ = Integer.MAX_VALUE;
        private int kMax_ = Integer.MIN_VALUE;
        private int jMax_ = Integer.MIN_VALUE;

        public int descendant(int index, int branch) {
            return this.k_.elementAt(index) - this.jMin_ - 1 + branch;
        }

        public double probability(int index, int branch) {
            return this.probs_.elementAt(branch).elementAt(index);
        }

        public int size() {
            return this.jMax_ - this.jMin_ + 1;
        }

        public int jMin() {
            return this.jMin_;
        }

        public int jMax() {
            return this.jMax_;
        }

        public void add(int k, double p1, double p2, double p3) {
            this.k_.add(k);
            Vector<Double> v1 = new Vector<Double>();
            Vector<Double> v2 = new Vector<Double>();
            Vector<Double> v3 = new Vector<Double>();
            v1.add(new Double(p1));
            v2.add(new Double(p2));
            v3.add(new Double(p3));
            this.probs_.add(v1);
            this.probs_.add(v2);
            this.probs_.add(v3);
            this.kMin_ = Math.min(this.kMin_, k);
            this.jMin_ = this.kMin_ - 1;
            this.kMax_ = Math.max(this.kMax_, k);
            this.jMax_ = this.kMax_ + 1;
        }
    }
}

