/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import java.util.Vector;
import org.jquantlib.QL;
import org.jquantlib.instruments.DiscretizedAsset;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.lattices.Lattice;
import org.jquantlib.time.TimeGrid;

public abstract class TreeLattice
extends Lattice {
    private final int n;
    private int statePricesLimit;
    protected Vector<Array> statePrices;

    public TreeLattice(TimeGrid t, int n) {
        super(t);
        this.n = n;
        if (n <= 0) {
            throw new IllegalStateException("there is no zeronomial lattice!");
        }
        this.statePrices = new Vector();
        this.statePrices.add(new Array(1).fill(1.0));
        this.statePricesLimit = 0;
    }

    public abstract double discount(int var1, int var2);

    public abstract int descendant(int var1, int var2, int var3);

    public abstract double probability(int var1, int var2, int var3);

    public abstract int size(int var1);

    protected void computeStatePrices(int until) {
        for (int i = this.statePricesLimit; i < until; ++i) {
            this.statePrices.add(new Array(this.size(i + 1)));
            for (int j = 0; j < this.size(i); ++j) {
                double disc = this.discount(i, j);
                double statePrice = this.statePrices.get(i).get(j);
                Array array = this.statePrices.get(i + 1);
                for (int l = 0; l < this.n; ++l) {
                    int index = this.descendant(i, j, l);
                    double oldValue = array.get(index);
                    array.set(index, oldValue + statePrice * disc * this.probability(i, j, l));
                }
            }
        }
        this.statePricesLimit = until;
    }

    public Array statePrices(int i) {
        if (i > this.statePricesLimit) {
            this.computeStatePrices(i);
        }
        return this.statePrices.get(i);
    }

    public void stepback(int i, Array values, Array newValues) {
        for (int j = 0; j < this.size(i); ++j) {
            double value = 0.0;
            for (int l = 0; l < this.n; ++l) {
                value += this.probability(i, j, l) * values.get(this.descendant(i, j, l));
            }
            newValues.set(j, value *= this.discount(i, j));
        }
    }

    @Override
    public double presentValue(DiscretizedAsset asset) {
        int i = this.t.index(asset.time());
        return asset.values().dotProduct(this.statePrices(i));
    }

    @Override
    public void initialize(DiscretizedAsset asset, double ti) {
        int i = this.t.index(ti);
        asset.setTime(ti);
        asset.reset(this.size(i));
    }

    @Override
    public void rollback(DiscretizedAsset asset, double to) {
        this.partialRollback(asset, to);
        asset.adjustValues();
    }

    @Override
    public void partialRollback(DiscretizedAsset asset, double to) {
        double from = asset.time();
        if (Closeness.isClose(from, to)) {
            return;
        }
        QL.require(from > to, "cannot roll the asset");
        int iFrom = this.t.index(from);
        int iTo = this.t.index(to);
        for (int i = iFrom - 1; i >= iTo; --i) {
            Array newValues = new Array(this.size(i));
            this.stepback(i, asset.values(), newValues);
            asset.setTime(this.t.get(i));
            asset.setValues(newValues);
            if (i == iTo) continue;
            asset.adjustValues();
        }
    }
}

