/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.instruments.Option;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.CurveDependentStepCondition;

public class ShoutCondition
extends CurveDependentStepCondition {
    private final double resTime;
    private final double rate;
    private double disc;

    public ShoutCondition(Option.Type type, double strike, double resTime, double rate) {
        super(type, strike);
        this.resTime = resTime;
        this.rate = rate;
    }

    public ShoutCondition(Array intrinsicValues, double resTime, double rate) {
        super(intrinsicValues);
        this.resTime = resTime;
        this.rate = rate;
    }

    @Override
    public void applyTo(Array a, double t) {
        this.disc = Math.exp(-this.rate * (t - this.resTime));
        super.applyTo(a, t);
    }

    @Override
    protected double applyToValue(double current, double intrinsic) {
        return Math.max(current, this.disc * intrinsic);
    }
}

