/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.math.LogGrid;
import org.jquantlib.math.TransformedGrid;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.PdeSecondOrderParabolic;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.time.Frequency;

public class PdeBSM
extends PdeSecondOrderParabolic {
    private final GeneralizedBlackScholesProcess process;

    public PdeBSM(GeneralizedBlackScholesProcess process) {
        this.process = process;
    }

    @Override
    public double diffusion(double t, double x) {
        return this.process.diffusion(t, x);
    }

    @Override
    public double discount(double t, double x) {
        if (Math.abs(t) < 1.0E-8) {
            t = 0.0;
        }
        return this.process.riskFreeRate().currentLink().forwardRate(t, t, Compounding.Continuous, Frequency.NoFrequency, true).rate();
    }

    @Override
    public double drift(double t, double x) {
        return this.process.drift(t, x);
    }

    @Override
    public TransformedGrid applyGridType(Array grid) {
        return new LogGrid(grid);
    }
}

