/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import java.util.List;
import java.util.Vector;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.BoundaryConditionSet;
import org.jquantlib.methods.finitedifferences.MixedScheme;
import org.jquantlib.methods.finitedifferences.Operator;

public abstract class ParallelEvolver<S extends Operator, T extends MixedScheme<S>> {
    private final List<T> evolvers;
    private final Class<? extends Operator> classS;
    private final Class<? extends MixedScheme> classT;

    public ParallelEvolver(Class<? extends Operator> classS, Class<? extends MixedScheme> classT, List<S> L, BoundaryConditionSet<BoundaryCondition<S>> bcs) {
        this.classS = classS;
        this.classT = classT;
        this.evolvers = new Vector<T>(L.size());
        for (int i = 0; i < L.size(); ++i) {
            this.evolvers.add(this.getEvolver((Operator)L.get(i), bcs.get(i)));
        }
    }

    public List<Array> step(List<Array> a, double t) {
        for (int i = 0; i < this.evolvers.size(); ++i) {
            a.set(i, ((MixedScheme)this.evolvers.get(i)).step(a.get(i), t));
        }
        return a;
    }

    public void setStep(double dt) {
        for (int i = 0; i < this.evolvers.size(); ++i) {
            ((MixedScheme)this.evolvers.get(i)).setStep(dt);
        }
    }

    protected T getEvolver(S l, List<BoundaryCondition<S>> bcs) {
        try {
            return (T)this.classT.getConstructor(Operator.class, List.class).newInstance(l, bcs);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }
}

