/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.statistics;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.statistics.GenericRiskStatistics;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, reviewers={"Richard Gomes"}, version=QualityAssurance.Version.V097)
public class IncrementalStatistics
extends GenericRiskStatistics {
    private static final String UNSUFFICIENT_SAMPLE_WEIGHT = "sampleWeight_=0, unsufficient";
    private static final String UNSUFFICIENT_SAMPLE_NUMBER = "sample number <=1, unsufficient";
    private static final String UNSUFFICIENT_SAMPLE_NUMBER_2 = "sample number <=2, unsufficient";
    private static final String UNSUFFICIENT_SAMPLE_NUMBER_3 = "sample number <=3, unsufficient";
    private static final String NEGATIVE_VARIANCE = "negative variance";
    private static final String EMPTY_SAMPLE_SET = "empty sample set";
    private static final String MAX_NUMBER_OF_SAMPLES_REACHED = "maximum number of samples reached";
    private static final String INCOMPATIBLE_ARRAY_SIZES = "incompatible array sizes";
    protected int sampleNumber_;
    protected int downsideSampleNumber_;
    protected double sampleWeight_;
    protected double downsideSampleWeight_;
    protected double sum_;
    protected double quadraticSum_;
    protected double downsideQuadraticSum_;
    protected double cubicSum_;
    protected double fourthPowerSum_;
    protected double min_;
    protected double max_;

    public IncrementalStatistics() {
        this.reset();
    }

    @Override
    public int samples() {
        return this.sampleNumber_;
    }

    @Override
    public double weightSum() {
        return this.sampleWeight_;
    }

    @Override
    public double mean() {
        QL.require(this.sampleWeight_ > 0.0, UNSUFFICIENT_SAMPLE_WEIGHT);
        return this.sum_ / this.sampleWeight_;
    }

    @Override
    public double variance() {
        QL.require(this.sampleWeight_ > 0.0, UNSUFFICIENT_SAMPLE_WEIGHT);
        QL.require(this.sampleNumber_ > 1, UNSUFFICIENT_SAMPLE_NUMBER);
        double m = this.mean();
        double v = this.quadraticSum_ / this.sampleWeight_;
        v -= m * m;
        QL.ensure((v *= (double)this.sampleNumber_ / ((double)this.sampleNumber_ - 1.0)) >= 0.0, NEGATIVE_VARIANCE);
        return v;
    }

    @Override
    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    @Override
    public double errorEstimate() {
        double var = this.variance();
        QL.require(this.samples() > 0, EMPTY_SAMPLE_SET);
        return Math.sqrt(var / (double)this.samples());
    }

    @Override
    public double downsideDeviation() {
        return Math.sqrt(this.downsideVariance());
    }

    @Override
    public double downsideVariance() {
        if (this.downsideSampleWeight_ == 0.0) {
            QL.require(this.sampleWeight_ > 0.0, UNSUFFICIENT_SAMPLE_WEIGHT);
            return 0.0;
        }
        QL.require(this.downsideSampleNumber_ > 1, "sample number below zero <=1, unsufficient");
        return (double)this.downsideSampleNumber_ / ((double)this.downsideSampleNumber_ - 1.0) * (this.downsideQuadraticSum_ / this.downsideSampleWeight_);
    }

    @Override
    public double skewness() {
        QL.require(this.sampleNumber_ > 2, UNSUFFICIENT_SAMPLE_NUMBER_2);
        double s = this.standardDeviation();
        if (s == 0.0) {
            return 0.0;
        }
        double m = this.mean();
        double result = this.cubicSum_ / this.sampleWeight_;
        result -= 3.0 * m * (this.quadraticSum_ / this.sampleWeight_);
        result += 2.0 * m * m * m;
        result /= s * s * s;
        result *= (double)this.sampleNumber_ / ((double)this.sampleNumber_ - 1.0);
        return result *= (double)this.sampleNumber_ / ((double)this.sampleNumber_ - 2.0);
    }

    @Override
    public double kurtosis() {
        QL.require(this.sampleNumber_ > 3, UNSUFFICIENT_SAMPLE_NUMBER_3);
        double m = this.mean();
        double v = this.variance();
        double c = ((double)this.sampleNumber_ - 1.0) / ((double)this.sampleNumber_ - 2.0);
        c *= ((double)this.sampleNumber_ - 1.0) / ((double)this.sampleNumber_ - 3.0);
        c *= 3.0;
        if (v == 0.0) {
            return c;
        }
        double result = this.fourthPowerSum_ / this.sampleWeight_;
        result -= 4.0 * m * (this.cubicSum_ / this.sampleWeight_);
        result += 6.0 * m * m * (this.quadraticSum_ / this.sampleWeight_);
        result -= 3.0 * m * m * m * m;
        result /= v * v;
        result *= (double)this.sampleNumber_ / ((double)this.sampleNumber_ - 1.0);
        result *= (double)this.sampleNumber_ / ((double)this.sampleNumber_ - 2.0);
        return (result *= ((double)this.sampleNumber_ + 1.0) / ((double)this.sampleNumber_ - 3.0)) - c;
    }

    @Override
    public double min() {
        QL.require(this.samples() > 0, EMPTY_SAMPLE_SET);
        return this.min_;
    }

    @Override
    public double max() {
        QL.require(this.samples() > 0, EMPTY_SAMPLE_SET);
        return this.max_;
    }

    @Override
    public void addSequence(double[] datum) {
        for (int i = 0; i < datum.length; ++i) {
            this.add(datum[i]);
        }
    }

    @Override
    public void addSequence(double[] datum, double[] weights) {
        QL.require(datum.length == weights.length, INCOMPATIBLE_ARRAY_SIZES);
        for (int i = 0; i < datum.length; ++i) {
            this.add(datum[i], weights[i]);
        }
    }

    @Override
    public void addSequence(Array datum) {
        for (int i = 0; i < datum.size(); ++i) {
            this.add(datum.get(i));
        }
    }

    @Override
    public void addSequence(Array datum, Array weights) {
        QL.require(datum.size() == weights.size(), INCOMPATIBLE_ARRAY_SIZES);
        for (int i = 0; i < datum.size(); ++i) {
            this.add(datum.get(i), weights.get(i));
        }
    }

    @Override
    public void add(double value) {
        this.add(value, 1.0);
    }

    @Override
    public void add(double value, double weight) {
        QL.require(weight >= 0.0, "negative weight not allowed");
        int oldSamples = this.sampleNumber_++;
        QL.ensure(this.sampleNumber_ > oldSamples, MAX_NUMBER_OF_SAMPLES_REACHED);
        this.sampleWeight_ += weight;
        double temp = weight * value;
        this.sum_ += temp;
        this.quadraticSum_ += (temp *= value);
        if (value < 0.0) {
            this.downsideQuadraticSum_ += temp;
            ++this.downsideSampleNumber_;
            this.downsideSampleWeight_ += weight;
        }
        this.cubicSum_ += (temp *= value);
        this.fourthPowerSum_ += (temp *= value);
        if (oldSamples == 0) {
            this.min_ = this.max_ = value;
        } else {
            this.min_ = Math.min(value, this.min_);
            this.max_ = Math.max(value, this.max_);
        }
    }

    @Override
    public void reset() {
        this.min_ = Double.MAX_VALUE;
        this.max_ = Double.MIN_VALUE;
        this.sampleNumber_ = 0;
        this.downsideSampleNumber_ = 0;
        this.sampleWeight_ = 0.0;
        this.downsideSampleWeight_ = 0.0;
        this.sum_ = 0.0;
        this.quadraticSum_ = 0.0;
        this.downsideQuadraticSum_ = 0.0;
        this.cubicSum_ = 0.0;
        this.fourthPowerSum_ = 0.0;
    }
}

