/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.Ops;
import org.jquantlib.math.functions.Bind2nd;
import org.jquantlib.math.functions.ComposedFunction;
import org.jquantlib.math.functions.Cube;
import org.jquantlib.math.functions.Everywhere;
import org.jquantlib.math.functions.Fourth;
import org.jquantlib.math.functions.Identity;
import org.jquantlib.math.functions.Minus;
import org.jquantlib.math.functions.Square;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.util.ComparablePair;
import org.jquantlib.util.Pair;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, reviewers={"Richard Gomes"}, version=QualityAssurance.Version.V097)
public abstract class GeneralStatistics {
    private List<ComparablePair<Double, Double>> samples;
    private boolean sorted;
    private static final String EMPTY_SAMPLE_SET = "empty sample set";
    private static final String NEGATIVE_WEIGHT_NOT_ALLOWED = "negative weight not allowed";
    private static final String INCOMPATIBLE_ARRAY_SIZES = "incompatible array sizes";

    public GeneralStatistics() {
        this.reset();
    }

    public void addSequence(double[] datum) {
        for (int i = 0; i < datum.length; ++i) {
            this.add(datum[i]);
        }
    }

    public void addSequence(double[] datum, double[] weights) {
        QL.require(datum.length == weights.length, INCOMPATIBLE_ARRAY_SIZES);
        for (int i = 0; i < datum.length; ++i) {
            this.add(datum[i], weights[i]);
        }
    }

    public void addSequence(Array datum) {
        for (int i = 0; i < datum.size(); ++i) {
            this.add(datum.get(i));
        }
    }

    public void addSequence(Array datum, Array weights) {
        QL.require(datum.size() == weights.size(), INCOMPATIBLE_ARRAY_SIZES);
        for (int i = 0; i < datum.size(); ++i) {
            this.add(datum.get(i), weights.get(i));
        }
    }

    public void reset() {
        this.samples = new ArrayList<ComparablePair<Double, Double>>();
        this.sorted = true;
    }

    public void sort() {
        if (!this.sorted) {
            Collections.sort(this.samples);
            this.sorted = true;
        }
    }

    public int samples() {
        return this.samples.size();
    }

    public List<ComparablePair<Double, Double>> data() {
        return Collections.unmodifiableList(this.samples);
    }

    public double weightSum() {
        double result = 0.0;
        for (ComparablePair<Double, Double> it : this.samples) {
            result += it.second().doubleValue();
        }
        return result;
    }

    public double mean() {
        int N = this.samples();
        QL.require(N != 0, EMPTY_SAMPLE_SET);
        return this.expectationValue(new Identity(), new Everywhere()).first();
    }

    public double variance() {
        int N = this.samples();
        QL.require(N > 1, "sample number <=1, unsufficient");
        double s2 = this.expectationValue(new ComposedFunction(new Square(), new Bind2nd(new Minus(), this.mean())), new Everywhere()).first();
        return s2 * (double)N / ((double)N - 1.0);
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double errorEstimate() {
        return Math.sqrt(this.variance() / (double)this.samples());
    }

    public double skewness() {
        int N = this.samples();
        QL.require(N > 2, "sample number <=2, unsufficient");
        double x = this.expectationValue(new ComposedFunction(new Cube(), new Bind2nd(new Minus(), this.mean())), new Everywhere()).first();
        double sigma = this.standardDeviation();
        return x / (sigma * sigma * sigma) * ((double)N / ((double)N - 1.0)) * ((double)N / ((double)N - 2.0));
    }

    public double kurtosis() {
        int N = this.samples();
        QL.require(N > 3, "sample number <=3, unsufficient");
        double x = this.expectationValue(new ComposedFunction(new Fourth(), new Bind2nd(new Minus(), this.mean())), new Everywhere()).first();
        double sigma2 = this.variance();
        double c1 = (double)N / ((double)N - 1.0) * ((double)N / ((double)N - 2.0)) * (((double)N + 1.0) / ((double)N - 3.0));
        double c2 = 3.0 * (((double)N - 1.0) / ((double)N - 2.0)) * (((double)N - 1.0) / ((double)N - 3.0));
        return c1 * (x / (sigma2 * sigma2)) - c2;
    }

    public double min() {
        QL.require(this.samples() > 0, EMPTY_SAMPLE_SET);
        return Collections.min(this.samples).first();
    }

    public double max() {
        QL.require(this.samples() > 0, EMPTY_SAMPLE_SET);
        return Collections.max(this.samples).first();
    }

    public final Pair<Double, Integer> expectationValue(Ops.DoubleOp f, Ops.DoublePredicate inRange) {
        double num = 0.0;
        double den = 0.0;
        int n = 0;
        for (ComparablePair<Double, Double> element : this.samples) {
            double x = element.first();
            double w = element.second();
            if (!inRange.op(x)) continue;
            num += f.op(x) * w;
            den += w;
            ++n;
        }
        if (n == 0) {
            return new Pair<Double, Integer>((Double)Double.MAX_VALUE, 0);
        }
        return new Pair<Double, Integer>(num / den, n);
    }

    public double percentile(double percent) {
        QL.require(percent > 0.0 && percent <= 1.0, "percentile must be in (0.0, 1.0]");
        double sampleWeight = this.weightSum();
        QL.require(sampleWeight > 0.0, EMPTY_SAMPLE_SET);
        this.sort();
        int k = 0;
        int l = this.samples.size() - 1;
        double target = percent * sampleWeight;
        for (double integral = this.samples.get(k).second().doubleValue(); integral < target && k != l; integral += this.samples.get(++k).second().doubleValue()) {
        }
        return this.samples.get(k).first();
    }

    public double topPercentile(double percent) {
        QL.require(percent > 0.0 && percent <= 1.0, "percentile must be in (0.0, 1.0]");
        double sampleWeight = this.weightSum();
        QL.require(sampleWeight > 0.0, EMPTY_SAMPLE_SET);
        this.sort();
        int k = this.samples.size() - 1;
        boolean l = false;
        double target = percent * sampleWeight;
        for (double integral = this.samples.get(k).second().doubleValue(); integral < target && k != 0; integral += this.samples.get(--k).second().doubleValue()) {
        }
        return this.samples.get(k).first();
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        QL.require(weight >= 0.0, NEGATIVE_WEIGHT_NOT_ALLOWED);
        this.samples.add(new ComparablePair<Double, Double>(value, weight));
        this.sorted = false;
    }
}

