/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.statistics;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.statistics.Statistics;
import org.jquantlib.util.Pair;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, reviewers={"Richard Gomes"}, version=QualityAssurance.Version.V097)
public class ConvergenceStatistics {
    private static final String INCOMPATIBLE_ARRAY_SIZES = "incompatible array sizes";
    private final Statistics statistics = new Statistics();
    private final DoublingConvergenceSteps samplingRule;
    private final List<Pair<Integer, Double>> table;
    private int nextSampleSize;

    public ConvergenceStatistics() {
        this(new DoublingConvergenceSteps());
    }

    public ConvergenceStatistics(DoublingConvergenceSteps rule) {
        this.samplingRule = rule;
        this.table = new ArrayList<Pair<Integer, Double>>();
        this.reset();
    }

    public int initialSamples() {
        return 1;
    }

    public int nextSamples(int current) {
        return 2 * current + 1;
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        this.statistics.add(value, weight);
        if (this.statistics.samples() == this.nextSampleSize) {
            this.table.add(new Pair<Integer, Double>(this.statistics.samples(), this.statistics.mean()));
            this.nextSampleSize = this.samplingRule.nextSamples(this.nextSampleSize);
        }
    }

    public void addSequence(double[] datum) {
        for (int i = 0; i < datum.length; ++i) {
            this.add(datum[i]);
        }
    }

    public void addSequence(double[] datum, double[] weights) {
        QL.require(datum.length == weights.length, INCOMPATIBLE_ARRAY_SIZES);
        for (int i = 0; i < datum.length; ++i) {
            this.add(datum[i], weights[i]);
        }
    }

    public void addSequence(Array datum) {
        for (int i = 0; i < datum.size(); ++i) {
            this.add(datum.get(i));
        }
    }

    public void addSequence(Array datum, Array weights) {
        QL.require(datum.size() == weights.size(), INCOMPATIBLE_ARRAY_SIZES);
        for (int i = 0; i < datum.size(); ++i) {
            this.add(datum.get(i), weights.get(i));
        }
    }

    public void reset() {
        this.statistics.reset();
        this.nextSampleSize = this.samplingRule.initialSamples();
        this.table.clear();
    }

    public List<Pair<Integer, Double>> convergenceTable() {
        return this.table;
    }

    private static class DoublingConvergenceSteps {
        private DoublingConvergenceSteps() {
        }

        public int initialSamples() {
            return 1;
        }

        public int nextSamples(int current) {
            return 2 * current + 1;
        }
    }
}

