/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.distributions.Derivative;

public class NewtonSafe
extends AbstractSolver1D<Derivative> {
    @Override
    protected double solveImpl(Derivative f, double xAccuracy) {
        double dxold;
        double xh;
        double xl;
        if (this.fxMin < 0.0) {
            xl = this.xMin;
            xh = this.xMax;
        } else {
            xh = this.xMin;
            xl = this.xMax;
        }
        double dx = dxold = this.xMax - this.xMin;
        double froot = f.op(this.root);
        double dfroot = f.derivative(this.root);
        ++this.evaluationNumber;
        while (this.evaluationNumber <= this.getMaxEvaluations()) {
            if (((this.root - xh) * dfroot - froot) * ((this.root - xl) * dfroot - froot) > 0.0 || Math.abs(2.0 * froot) > Math.abs(dxold * dfroot)) {
                dxold = dx;
                dx = (xh - xl) / 2.0;
                this.root = xl + dx;
            } else {
                dxold = dx;
                dx = froot / dfroot;
                this.root -= dx;
            }
            if (Math.abs(dx) < xAccuracy) {
                return this.root;
            }
            froot = f.op(this.root);
            dfroot = f.derivative(this.root);
            ++this.evaluationNumber;
            if (froot < 0.0) {
                xl = this.root;
                continue;
            }
            xh = this.root;
        }
        throw new ArithmeticException("maximum number of function evaluations exceeded");
    }
}

