/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.randomnumbers.RandomNumberGenerator;
import org.jquantlib.math.randomnumbers.UniformRandomSequenceGenerator;
import org.jquantlib.methods.montecarlo.Sample;

public class RandomSequenceGenerator<RNG extends RandomNumberGenerator>
implements UniformRandomSequenceGenerator {
    private final int dimension;
    private final RNG rng;
    private final double[] sequence;
    private final long[] int32Sequence;
    private final Class<? extends RandomNumberGenerator> classRNG;

    public RandomSequenceGenerator(Class<? extends RandomNumberGenerator> classRNG, int dimensionality, RNG rng) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        QL.require(dimensionality >= 1, "dimensionality must be greater than 0");
        this.classRNG = classRNG;
        this.dimension = dimensionality;
        this.rng = rng;
        this.sequence = new double[this.dimension];
        this.int32Sequence = new long[this.dimension];
    }

    public RandomSequenceGenerator(Class<? extends RandomNumberGenerator> classRNG, int dimensionality) {
        this(classRNG, dimensionality, 0L);
    }

    public RandomSequenceGenerator(Class<? extends RandomNumberGenerator> classRNG, int dimensionality, long seed) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.classRNG = classRNG;
        if (dimensionality < 1) {
            throw new IllegalArgumentException("dimensionality must be greater than 0");
        }
        this.dimension = dimensionality;
        this.sequence = new double[this.dimension];
        this.int32Sequence = new long[this.dimension];
        try {
            this.rng = classRNG.getConstructor(Long.TYPE).newInstance(seed);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public final Sample<double[]> lastSequence() {
        return new Sample<double[]>(this.sequence, 1.0);
    }

    @Override
    public final Sample<double[]> nextSequence() {
        double weight = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            Sample<Double> sample = this.rng.next();
            this.sequence[i] = sample.value();
            weight *= sample.weight();
        }
        return new Sample<double[]>(this.sequence, weight);
    }

    @Override
    public long[] nextInt32Sequence() {
        for (int i = 0; i < this.dimension; ++i) {
            this.int32Sequence[i] = this.rng.nextInt32();
        }
        return this.int32Sequence;
    }
}

