/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.optimization.CostFunction;
import org.jquantlib.math.optimization.LeastSquareProblem;

public class LeastSquareFunction
extends CostFunction {
    protected LeastSquareProblem lsp_;

    LeastSquareFunction(LeastSquareProblem lsp) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.lsp_ = lsp;
    }

    @Override
    public double value(Array x) {
        Array target = new Array(this.lsp_.size());
        Array fct2fit = new Array(this.lsp_.size());
        this.lsp_.targetAndValue(x, target, fct2fit);
        Array diff = target.sub(fct2fit);
        return diff.dotProduct(diff);
    }

    @Override
    public void gradient(Array grad_f, Array x) {
        Array target = new Array(this.lsp_.size());
        Array fct2fit = new Array(this.lsp_.size());
        Matrix grad_fct2fit = new Matrix(this.lsp_.size(), x.size());
        this.lsp_.targetValueAndGradient(x, grad_fct2fit, target, fct2fit);
        Array diff = target.sub(fct2fit);
    }

    @Override
    public double valueAndGradient(Array grad_f, Array x) {
        Array target = new Array(this.lsp_.size());
        Array fct2fit = new Array(this.lsp_.size());
        Matrix grad_fct2fit = new Matrix(this.lsp_.size(), x.size());
        this.lsp_.targetValueAndGradient(x, grad_fct2fit, target, fct2fit);
        Array diff = target.sub(fct2fit);
        return diff.dotProduct(diff);
    }

    @Override
    public Array values(Array x) {
        throw new UnsupportedOperationException("Work in progress");
    }
}

