/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.LineSearch;
import org.jquantlib.math.optimization.Problem;

public class ArmijoLineSearch
extends LineSearch {
    private final double alpha_;
    private final double beta_;

    public ArmijoLineSearch() {
        this(1.0E-8, 0.05, 0.65);
    }

    public ArmijoLineSearch(double eps, double alpha, double beta) {
        super(eps);
        this.alpha_ = alpha;
        this.beta_ = beta;
    }

    @Override
    public double evaluate(Problem P, EndCriteria.Type ecType, EndCriteria endCriteria, double t_ini) {
        Constraint constraint = P.constraint();
        this.succeed_ = true;
        boolean maxIter = false;
        double qtold = t_ini;
        double t = t_ini;
        int loopNumber = 0;
        double q0 = P.functionValue();
        double qpO = P.gradientNormValue();
        this.qt_ = q0;
        this.qpt_ = this.gradient_.empty() ? qpO : -this.gradient_.dotProduct(this.searchDirection_);
        this.gradient_ = new Array(P.currentValue().size());
        this.xtd_ = P.currentValue();
        t = this.update(this.xtd_, this.searchDirection_, t, constraint);
        this.qt_ = P.value(this.xtd_);
        if (this.qt_ - q0 > -this.alpha_ * t * this.qpt_) {
            do {
                ++loopNumber;
                t *= this.beta_;
                qtold = this.qt_;
                this.xtd_ = P.currentValue();
                t = this.update(this.xtd_, this.searchDirection_, t, constraint);
                this.qt_ = P.value(this.xtd_);
                P.gradient(this.gradient_, this.xtd_);
                maxIter = endCriteria.checkMaxIterations(loopNumber, ecType);
            } while ((this.qt_ - q0 > -this.alpha_ * t * this.qpt_ || qtold - q0 <= -this.alpha_ * t * this.qpt_ / this.beta_) && !maxIter);
        }
        if (maxIter) {
            this.succeed_ = false;
        }
        P.gradient(this.gradient_, this.xtd_);
        this.qpt_ = this.gradient_.dotProduct(this.gradient_);
        return t;
    }
}

