/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities.internal;

import java.util.EnumSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.math.matrixutilities.internal.DirectAddress;

public class DirectArrayColAddress
extends DirectAddress
implements Address.ArrayAddress {
    public DirectArrayColAddress(double[] data, int row0, int row1, Address chain, int col, Set<Address.Flags> flags, boolean contiguous, int rows, int cols) {
        super(data, row0, row1, chain, col, col + 1, flags, contiguous, rows, cols);
    }

    @Override
    public Address.ArrayAddress toFortran() {
        return this.isFortran() ? this : new DirectArrayColAddress(this.data, this.row0, this.row1, this.chain, this.col0, EnumSet.of(Address.Flags.FORTRAN), this.contiguous, this.rows, this.cols);
    }

    @Override
    public Address.ArrayAddress toJava() {
        return this.isFortran() ? new DirectArrayColAddress(this.data, this.row0 + 1, this.row1 + 1, this.chain, this.col0 + 1, EnumSet.noneOf(Address.Flags.class), this.contiguous, this.rows, this.cols) : this;
    }

    @Override
    public Address.ArrayAddress.ArrayOffset offset() {
        return new DirectArrayColAddressOffset(this.offset, this.offset);
    }

    @Override
    public Address.ArrayAddress.ArrayOffset offset(int index) {
        return new DirectArrayColAddressOffset(index, this.offset);
    }

    @Override
    public int op(int index) {
        return (this.row0 + index) * this.cols + (this.col0 + this.offset);
    }

    @Override
    public DirectArrayColAddress clone() {
        try {
            return (DirectArrayColAddress)super.clone();
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    private class DirectArrayColAddressOffset
    extends DirectAddress.DirectAddressOffset
    implements Address.ArrayAddress.ArrayOffset {
        public DirectArrayColAddressOffset(int row, int col) {
            this.row = DirectArrayColAddress.this.row0 + row;
            this.col = DirectArrayColAddress.this.col0 + col;
        }

        @Override
        public int op() {
            return this.row * DirectArrayColAddress.this.cols + this.col;
        }

        @Override
        public void setIndex(int index) {
            this.row = DirectArrayColAddress.this.row0 + index;
        }

        @Override
        public void add(Double e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            int n;
            if (this.row == DirectArrayColAddress.this.rows) {
                n = DirectArrayColAddress.this.rows;
            } else {
                int n2 = this.row;
                n = n2;
                this.row = n2 + 1;
            }
            return n;
        }

        @Override
        public int previousIndex() {
            int n;
            if (this.row == -1) {
                n = -1;
            } else {
                int n2 = this.row;
                n = n2;
                this.row = n2 - 1;
            }
            return n;
        }

        @Override
        public boolean hasNext() {
            return this.row < DirectArrayColAddress.this.row1;
        }

        @Override
        public boolean hasPrevious() {
            return this.row > -1;
        }

        @Override
        public Double next() {
            int idx = this.op();
            this.nextIndex();
            if (idx >= DirectArrayColAddress.this.row1) {
                throw new NoSuchElementException();
            }
            return DirectArrayColAddress.this.data[idx];
        }

        @Override
        public Double previous() {
            int idx = this.previousIndex();
            if (idx == -1) {
                throw new NoSuchElementException();
            }
            return DirectArrayColAddress.this.data[this.op()];
        }

        @Override
        public void set(Double e) {
            int idx = this.op();
            if (idx == -1 || idx == DirectArrayColAddress.this.rows) {
                throw new IllegalStateException();
            }
            DirectArrayColAddress.this.data[idx] = e;
        }
    }
}

