/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.matrixutilities;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Cells;
import org.jquantlib.math.matrixutilities.CholeskyDecomposition;
import org.jquantlib.math.matrixutilities.EigenvalueDecomposition;
import org.jquantlib.math.matrixutilities.Identity;
import org.jquantlib.math.matrixutilities.LUDecomposition;
import org.jquantlib.math.matrixutilities.QRDecomposition;
import org.jquantlib.math.matrixutilities.SVD;
import org.jquantlib.math.matrixutilities.SymmetricSchurDecomposition;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.math.matrixutilities.internal.DirectArrayColAddress;
import org.jquantlib.math.matrixutilities.internal.DirectArrayRowAddress;
import org.jquantlib.math.matrixutilities.internal.DirectMatrixAddress;
import org.jquantlib.math.matrixutilities.internal.MappedMatrixAddress;

@QualityAssurance(quality=QualityAssurance.Quality.Q1_TRANSLATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class Matrix
extends Cells<Address.MatrixAddress>
implements Cloneable {
    public Matrix() {
        this(EnumSet.noneOf(Address.Flags.class));
    }

    public Matrix(Set<Address.Flags> flags) {
        super(1, 1, null);
        this.addr = new DirectMatrixAddress(this.$, 0, 1, null, 0, 1, flags, true, 1, 1);
    }

    public Matrix(int rows, int cols) {
        this(rows, cols, (Set<Address.Flags>)EnumSet.noneOf(Address.Flags.class));
    }

    public Matrix(int rows, int cols, Set<Address.Flags> flags) {
        super(rows, cols, null);
        this.addr = new DirectMatrixAddress(this.$, 0, rows, null, 0, cols, flags, true, rows, cols);
    }

    public Matrix(double[][] data) {
        this(data, EnumSet.noneOf(Address.Flags.class));
    }

    public Matrix(double[][] data, Set<Address.Flags> flags) {
        super(data.length, data[0].length, null);
        this.addr = new DirectMatrixAddress(this.$, 0, data.length, null, 0, data[0].length, flags, true, data.length, data[0].length);
        for (int row = 0; row < data.length; ++row) {
            System.arraycopy(data[row], 0, this.$, row * this.cols, this.cols);
        }
    }

    public Matrix(Matrix m) {
        super(m.rows(), m.cols(), Matrix.copyData(m), ((Address.MatrixAddress)m.addr).clone());
    }

    private static final double[] copyData(Matrix m) {
        int size = m.rows() * m.cols();
        double[] data = new double[size];
        if (((Address.MatrixAddress)m.addr).isContiguous()) {
            System.arraycopy(m.$, 0, data, 0, size);
        } else {
            Address.MatrixAddress.MatrixOffset offset = ((Address.MatrixAddress)m.addr).offset();
            int cols = m.cols();
            for (int row = 0; row < m.rows(); ++row) {
                System.arraycopy(m.$, offset.op(), data, row * cols, cols);
                offset.nextRow();
            }
        }
        return data;
    }

    public Matrix(int rows, int cols, double[] data, Address.MatrixAddress addr) {
        super(rows, cols, data, addr);
    }

    @Deprecated
    public int _(int row, int col) {
        return ((Address.MatrixAddress)this.addr).op(row, col);
    }

    public double get(int row, int col) {
        return this.$[((Address.MatrixAddress)this.addr).op(row, col)];
    }

    public void set(int row, int col, double value) {
        this.$[((Address.MatrixAddress)this.addr).op((int)row, (int)col)] = value;
    }

    public Matrix addAssign(Matrix another) {
        QL.require(this.rows() == another.rows() && this.cols() == another.cols(), "matrix is incompatible");
        if (((Address.MatrixAddress)this.addr).isContiguous() && ((Address.MatrixAddress)another.addr).isContiguous()) {
            for (int i = 0; i < this.size(); ++i) {
                int n = i;
                this.$[n] = this.$[n] + another.$[i];
            }
        } else {
            int addr = 0;
            Address.MatrixAddress.MatrixOffset toff = ((Address.MatrixAddress)this.addr).offset();
            Address.MatrixAddress.MatrixOffset aoff = ((Address.MatrixAddress)another.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                toff.setRow(row);
                aoff.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    int n = toff.op();
                    this.$[n] = this.$[n] + another.$[aoff.op()];
                    ++addr;
                    toff.nextCol();
                    aoff.nextCol();
                }
            }
        }
        return this;
    }

    public Matrix subAssign(Matrix another) {
        QL.require(this.rows() == another.rows() && this.cols() == another.cols(), "matrix is incompatible");
        if (((Address.MatrixAddress)this.addr).isContiguous() && ((Address.MatrixAddress)another.addr).isContiguous()) {
            for (int i = 0; i < this.size(); ++i) {
                int n = i;
                this.$[n] = this.$[n] - another.$[i];
            }
        } else {
            int addr = 0;
            Address.MatrixAddress.MatrixOffset toff = ((Address.MatrixAddress)this.addr).offset();
            Address.MatrixAddress.MatrixOffset aoff = ((Address.MatrixAddress)another.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                toff.setRow(row);
                aoff.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    int n = toff.op();
                    this.$[n] = this.$[n] - another.$[aoff.op()];
                    ++addr;
                    toff.nextCol();
                    aoff.nextCol();
                }
            }
        }
        return this;
    }

    public Matrix mulAssign(double scalar) {
        if (((Address.MatrixAddress)this.addr).isContiguous()) {
            int addr = 0;
            while (addr < this.size()) {
                int n = addr++;
                this.$[n] = this.$[n] * scalar;
            }
        } else {
            Address.MatrixAddress.MatrixOffset dst = ((Address.MatrixAddress)this.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                dst.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    int n = dst.op();
                    this.$[n] = this.$[n] * scalar;
                    dst.nextCol();
                }
            }
        }
        return this;
    }

    public Matrix divAssign(double scalar) {
        if (((Address.MatrixAddress)this.addr).isContiguous()) {
            int addr = 0;
            while (addr < this.size()) {
                int n = addr++;
                this.$[n] = this.$[n] / scalar;
            }
        } else {
            Address.MatrixAddress.MatrixOffset dst = ((Address.MatrixAddress)this.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                dst.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    int n = dst.op();
                    this.$[n] = this.$[n] / scalar;
                    dst.nextCol();
                }
            }
        }
        return this;
    }

    public Matrix add(Matrix another) {
        QL.require(this.rows() == another.rows() && this.cols() == another.cols(), "matrix is incompatible");
        Matrix result = new Matrix(this.rows(), this.cols());
        if (((Address.MatrixAddress)this.addr).isContiguous() && ((Address.MatrixAddress)another.addr).isContiguous()) {
            for (int i = 0; i < this.size(); ++i) {
                result.$[i] = this.$[i] + another.$[i];
            }
        } else {
            int addr = 0;
            Address.MatrixAddress.MatrixOffset toff = ((Address.MatrixAddress)this.addr).offset();
            Address.MatrixAddress.MatrixOffset aoff = ((Address.MatrixAddress)another.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                toff.setRow(row);
                aoff.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    result.$[addr] = this.$[toff.op()] + another.$[aoff.op()];
                    ++addr;
                    toff.nextCol();
                    aoff.nextCol();
                }
            }
        }
        return result;
    }

    public Matrix sub(Matrix another) {
        QL.require(this.rows() == another.rows() && this.cols() == another.cols(), "matrix is incompatible");
        Matrix result = new Matrix(this.rows(), this.cols());
        if (((Address.MatrixAddress)this.addr).isContiguous() && ((Address.MatrixAddress)another.addr).isContiguous()) {
            for (int addr = 0; addr < this.size(); ++addr) {
                result.$[addr] = this.$[addr] - another.$[addr];
            }
        } else {
            int addr = 0;
            Address.MatrixAddress.MatrixOffset toff = ((Address.MatrixAddress)this.addr).offset();
            Address.MatrixAddress.MatrixOffset aoff = ((Address.MatrixAddress)another.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                toff.setRow(row);
                aoff.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    result.$[addr] = this.$[toff.op()] - another.$[aoff.op()];
                    ++addr;
                    toff.nextCol();
                    aoff.nextCol();
                }
            }
        }
        return result;
    }

    public Matrix negative() {
        return this.mulAssign(-1.0);
    }

    public Matrix mul(double scalar) {
        Matrix result = new Matrix(this.rows(), this.cols());
        if (((Address.MatrixAddress)this.addr).isContiguous()) {
            for (int addr = 0; addr < this.size(); ++addr) {
                result.$[addr] = this.$[addr] * scalar;
            }
        } else {
            int addr = 0;
            Address.MatrixAddress.MatrixOffset src = ((Address.MatrixAddress)this.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                src.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    result.$[addr] = this.$[src.op()] * scalar;
                    ++addr;
                    src.nextCol();
                }
            }
        }
        return result;
    }

    public Matrix div(double scalar) {
        Matrix result = new Matrix(this.rows(), this.cols());
        if (((Address.MatrixAddress)this.addr).isContiguous()) {
            for (int addr = 0; addr < this.size(); ++addr) {
                result.$[addr] = this.$[addr] / scalar;
            }
        } else {
            int addr = 0;
            Address.MatrixAddress.MatrixOffset src = ((Address.MatrixAddress)this.addr).offset();
            for (int row = 0; row < this.rows(); ++row) {
                src.setRow(row);
                for (int col = 0; col < this.cols(); ++col) {
                    result.$[addr] = this.$[src.op()] / scalar;
                    ++addr;
                    src.nextCol();
                }
            }
        }
        return result;
    }

    public Array mul(Array array) {
        QL.require(this.cols() == array.size(), "array is incompatible");
        Array result = new Array(this.rows(), this.flags());
        Address.MatrixAddress.MatrixOffset toff = ((Address.MatrixAddress)this.addr).offset();
        Address.ArrayAddress.ArrayOffset aoff = ((Address.ArrayAddress)array.addr).offset();
        int offsetT = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        int offsetA = ((Address.ArrayAddress)array.addr).isFortran() ? 1 : 0;
        for (int row = offsetT; row < result.size() + offsetT; ++row) {
            toff.setRow(row);
            toff.setCol(offsetT);
            aoff.setIndex(offsetA);
            double sum = 0.0;
            for (int col = offsetT; col < this.cols() + offsetT; ++col) {
                double telem = this.$[toff.op()];
                double aelem = array.$[aoff.op()];
                sum += telem * aelem;
                toff.nextCol();
                aoff.nextIndex();
            }
            result.$[result._((int)row)] = sum;
        }
        return result;
    }

    public Matrix mul(Matrix another) {
        int offsetA;
        QL.require(this.cols() == another.rows(), "matrix is incompatible");
        Matrix result = new Matrix(this.rows(), another.cols(), this.flags());
        Address.MatrixAddress.MatrixOffset toff = ((Address.MatrixAddress)this.addr).offset();
        Address.MatrixAddress.MatrixOffset aoff = ((Address.MatrixAddress)another.addr).offset();
        int offsetT = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        for (int col = offsetA = ((Address.MatrixAddress)another.addr).isFortran() ? 1 : 0; col < another.cols() + offsetA; ++col) {
            for (int row = offsetT; row < this.rows() + offsetT; ++row) {
                toff.setRow(row);
                toff.setCol(offsetT);
                aoff.setRow(offsetA);
                aoff.setCol(col);
                double sum = 0.0;
                for (int i = 0; i < this.cols(); ++i) {
                    double telem = this.$[toff.op()];
                    double aelem = another.$[aoff.op()];
                    sum += telem * aelem;
                    toff.nextCol();
                    aoff.nextRow();
                }
                result.$[((Address.MatrixAddress)result.addr).op((int)row, (int)(col - offsetA + offsetT))] = sum;
            }
        }
        return result;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public QRDecomposition qr(boolean pivot) {
        return new QRDecomposition(this, pivot);
    }

    public CholeskyDecomposition cholesky() {
        return new CholeskyDecomposition(this);
    }

    public SymmetricSchurDecomposition schur() {
        return new SymmetricSchurDecomposition(this);
    }

    public SVD svd() {
        return new SVD(this);
    }

    public EigenvalueDecomposition eigenvalue() {
        return new EigenvalueDecomposition(this);
    }

    public Matrix transpose() {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        Matrix result = new Matrix(this.cols(), this.rows(), this.flags());
        Address.MatrixAddress.MatrixOffset src = ((Address.MatrixAddress)this.addr).offset(offset, offset);
        Address.MatrixAddress.MatrixOffset dst = ((Address.MatrixAddress)result.addr).offset(offset, offset);
        for (int row = offset; row < this.rows() + offset; ++row) {
            src.setRow(row);
            src.setCol(offset);
            dst.setRow(offset);
            dst.setCol(row);
            for (int col = offset; col < this.cols() + offset; ++col) {
                result.$[dst.op()] = this.$[src.op()];
                src.nextCol();
                dst.nextRow();
            }
        }
        return result;
    }

    public Array diagonal() {
        QL.require(this.rows() == this.cols(), "matrix must be square");
        Array result = new Array(this.cols());
        int addr = 0;
        for (int i = 0; i < this.cols(); ++i) {
            result.$[i] = this.$[addr];
            addr += this.cols() + 1;
        }
        return result;
    }

    public double determinant() {
        return new LUDecomposition(this).det();
    }

    public Matrix inverse() {
        QL.require(this.rows == this.cols, "matrix is not square");
        return new LUDecomposition(this).solve(new Identity(this.rows()));
    }

    public Array rangeRow(int row) {
        return this.rangeRow(row, 0, this.cols());
    }

    public Array rangeRow(int row, int col0) {
        return this.rangeRow(row, col0, this.cols());
    }

    public Array rangeRow(int row, int col0, int col1) {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(row >= offset && row <= this.rows() + offset, ArrayIndexOutOfBoundsException.class, "invalid row index");
        QL.require(col0 >= offset && col0 < this.cols() + offset && col1 >= offset && col1 <= this.cols() + offset, ArrayIndexOutOfBoundsException.class, "invalid column index");
        QL.require(col0 <= col1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        return new RangeRow(row - offset, (Address.MatrixAddress)this.addr, col0 - offset, col1 - offset, this.$, this.rows(), this.cols());
    }

    public Array rangeCol(int col) {
        return this.rangeCol(col, 0, this.rows());
    }

    public Array rangeCol(int col, int row0) {
        return this.rangeCol(col, row0, this.rows());
    }

    public Array rangeCol(int col, int row0, int row1) {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(col >= offset && col <= this.cols() + offset, ArrayIndexOutOfBoundsException.class, "invalid column index");
        QL.require(row0 >= offset && row0 < this.rows() + offset && row1 >= offset && row1 <= this.rows() + offset, ArrayIndexOutOfBoundsException.class, "invalid row index");
        QL.require(row0 <= row1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        return new RangeCol(row0 - offset, row1 - offset, (Address.MatrixAddress)this.addr, col - offset, this.$, this.rows(), this.cols());
    }

    public Matrix range(int row0, int row1, int col0, int col1) {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(row0 >= offset && row0 < this.rows() + offset && row1 >= offset && row1 <= this.rows() + offset, ArrayIndexOutOfBoundsException.class, "invalid row index");
        QL.require(row0 <= row1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        QL.require(col0 >= offset && col0 < this.cols() + offset && col1 >= offset && col1 <= this.cols() + offset, ArrayIndexOutOfBoundsException.class, "invalid column index");
        QL.require(col0 <= col1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        boolean contiguous = super.cols() == col1 - col0 + 1;
        return new RangeMatrix(row0 - offset, row1 - offset, (Address.MatrixAddress)this.addr, col0 - offset, col1 - offset, contiguous, this.$, this.rows(), this.cols());
    }

    public Matrix range(int[] ridx, int col0, int col1) {
        return new RangeMatrix(ridx, (Address.MatrixAddress)this.addr, col0, col1, this.$, this.rows(), this.cols());
    }

    public Matrix range(int row0, int row1, int[] cidx) {
        return new RangeMatrix(row0, row1, (Address.MatrixAddress)this.addr, cidx, this.$, this.rows(), this.cols());
    }

    public Matrix range(int[] ridx, int[] cidx) {
        return new RangeMatrix(ridx, (Address.MatrixAddress)this.addr, cidx, this.$, this.rows(), this.cols());
    }

    public Array constRangeRow(int row) {
        return this.constRangeRow(row, 0, this.cols());
    }

    public Array constRangeRow(int row, int col0) {
        return this.constRangeRow(row, col0, this.cols());
    }

    public Array constRangeRow(int row, int col0, int col1) {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(row >= offset && row < this.rows() + offset, ArrayIndexOutOfBoundsException.class, "invalid row index");
        QL.require(col0 >= offset && col0 < this.cols() + offset && col1 >= offset && col1 <= this.cols() + offset, ArrayIndexOutOfBoundsException.class, "invalid column index");
        QL.require(col0 <= col1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        return new ConstRangeRow(row, (Address.MatrixAddress)this.addr, col0, col1, this.$, this.rows(), this.cols());
    }

    public Array constRangeCol(int col) {
        return this.constRangeCol(col, 0, this.rows());
    }

    public Array constRangeCol(int col, int row0) {
        return this.constRangeCol(col, row0, this.rows());
    }

    public Array constRangeCol(int col, int row0, int row1) {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(col >= offset && col < this.cols() + offset, ArrayIndexOutOfBoundsException.class, "invalid column index");
        QL.require(row0 >= offset && row0 < this.rows() + offset && row1 >= offset && row1 <= this.rows() + offset, ArrayIndexOutOfBoundsException.class, "invalid row index");
        QL.require(row0 <= row1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        return new ConstRangeCol(row0, row1, (Address.MatrixAddress)this.addr, col, this.$, this.rows(), this.cols());
    }

    public Matrix constRange(int row0, int row1, int col0, int col1) {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        QL.require(row0 >= offset && row0 < this.rows() + offset && row1 >= offset && row1 <= this.rows() + offset, ArrayIndexOutOfBoundsException.class, "invalid row index");
        QL.require(row0 <= row1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        QL.require(col0 >= offset && col0 < this.cols() + offset && col1 >= offset && col1 <= this.cols() + offset, ArrayIndexOutOfBoundsException.class, "invalid column index");
        QL.require(col0 <= col1, ArrayIndexOutOfBoundsException.class, "invalid backward indexing");
        boolean contiguous = super.cols() == col1 - col0 + 1;
        return new ConstRangeMatrix(row0, row1, (Address.MatrixAddress)this.addr, col0, col1, contiguous, this.$, this.rows(), this.cols());
    }

    public Matrix constRange(int[] ridx, int col0, int col1) {
        return new ConstRangeMatrix(ridx, (Address.MatrixAddress)this.addr, col0, col1, this.$, this.rows(), this.cols());
    }

    public Matrix constRange(int row0, int row1, int[] cidx) {
        return new ConstRangeMatrix(row0, row1, (Address.MatrixAddress)this.addr, cidx, this.$, this.rows(), this.cols());
    }

    public Matrix constRange(int[] ridx, int[] cidx) {
        return new ConstRangeMatrix(ridx, (Address.MatrixAddress)this.addr, cidx, this.$, this.rows(), this.cols());
    }

    public Matrix toFortran() {
        return ((Address.MatrixAddress)this.addr).isFortran() ? this : new Matrix(this.rows, this.cols, this.$, ((Address.MatrixAddress)this.addr).toFortran());
    }

    public Matrix toJava() {
        return ((Address.MatrixAddress)this.addr).isFortran() ? new Matrix(this.rows, this.cols, this.$, ((Address.MatrixAddress)this.addr).toJava()) : this;
    }

    public Matrix fill(double scalar) {
        QL.require(((Address.MatrixAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        Arrays.fill(this.$, ((Address.MatrixAddress)this.addr).base(), this.size(), scalar);
        return this;
    }

    public Matrix fill(Matrix another) {
        QL.require(((Address.MatrixAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(((Address.MatrixAddress)another.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(this.rows() == another.rows() && this.cols() == another.cols() && this.size() == another.size(), "wrong buffer length");
        System.arraycopy(another.$, ((Address.MatrixAddress)another.addr).base(), this.$, ((Address.MatrixAddress)this.addr).base(), this.size());
        return this;
    }

    public void fillRow(int row, Array array) {
        QL.require(this.cols() == array.size(), "array is incompatible");
        if (((Address.MatrixAddress)this.addr).isContiguous() && ((Address.ArrayAddress)array.addr).isContiguous()) {
            System.arraycopy(array.$, 0, this.$, ((Address.MatrixAddress)this.addr).op(row, 0), this.cols());
        } else {
            Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)array.addr).offset();
            Address.MatrixAddress.MatrixOffset dst = ((Address.MatrixAddress)this.addr).offset(row, 0);
            for (int col = 0; col < this.cols(); ++col) {
                this.$[dst.op()] = array.$[src.op()];
                src.nextIndex();
                dst.nextCol();
            }
        }
    }

    public void fillCol(int col, Array array) {
        QL.require(this.rows() == array.size(), "array is incompatible");
        if (((Address.MatrixAddress)this.addr).isContiguous() && ((Address.ArrayAddress)array.addr).isContiguous() && this.cols() == 1) {
            System.arraycopy(array.$, 0, this.$, 0, this.size());
        } else {
            Address.ArrayAddress.ArrayOffset src = ((Address.ArrayAddress)array.addr).offset();
            Address.MatrixAddress.MatrixOffset dst = ((Address.MatrixAddress)this.addr).offset(0, col);
            for (int row = 0; row < this.rows(); ++row) {
                this.$[dst.op()] = array.$[src.op()];
                src.nextIndex();
                dst.nextRow();
            }
        }
    }

    public Matrix swap(Matrix another) {
        QL.require(((Address.MatrixAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(((Address.MatrixAddress)another.addr).isContiguous(), "Operation not supported on non-contiguous data");
        QL.require(this.rows() == another.rows() && this.cols() == another.cols() && this.size() == another.size(), "wrong buffer length");
        double[] tdata = this.$;
        this.$ = another.$;
        another.$ = tdata;
        Address.MatrixAddress taddr = (Address.MatrixAddress)this.addr;
        this.addr = another.addr;
        another.addr = taddr;
        return this;
    }

    public Matrix sort() {
        QL.require(((Address.MatrixAddress)this.addr).isContiguous(), "Operation not supported on non-contiguous data");
        Arrays.sort(this.$, ((Address.MatrixAddress)this.addr).base(), ((Address.MatrixAddress)this.addr).last());
        return this;
    }

    @Override
    public Matrix clone() {
        Matrix clone = (Matrix)super.clone();
        clone.$ = Matrix.copyData(this);
        clone.addr = new DirectMatrixAddress(clone.$, 0, this.rows, null, 0, this.cols, this.flags(), true, this.rows, this.cols);
        return clone;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        int offset = ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
        StringBuffer sb = new StringBuffer();
        sb.append("[rows=").append(this.rows()).append(" cols=").append(this.cols()).append(" addr=").append(this.addr).append('\n');
        for (int row = offset; row < this.rows() + offset; ++row) {
            sb.append("  [ ");
            sb.append(this.$[((Address.MatrixAddress)this.addr).op(row, offset)]);
            for (int col = 1 + offset; col < this.cols() + offset; ++col) {
                sb.append(", ");
                sb.append(this.$[((Address.MatrixAddress)this.addr).op(row, col)]);
            }
            sb.append("  ]\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    public int offset() {
        return ((Address.MatrixAddress)this.addr).isFortran() ? 1 : 0;
    }

    private static class ConstRangeMatrix
    extends RangeMatrix {
        public ConstRangeMatrix(int row0, int row1, Address.MatrixAddress chain, int col0, int col1, boolean contiguous, double[] data, int rows, int cols) {
            super(row0, row1, chain, col0, col1, contiguous, data, rows, cols);
        }

        public ConstRangeMatrix(int[] ridx, Address.MatrixAddress chain, int col0, int col1, double[] data, int rows, int cols) {
            super(ridx, chain, col0, col1, data, rows, cols);
        }

        public ConstRangeMatrix(int row0, int row1, Address.MatrixAddress chain, int[] cidx, double[] data, int rows, int cols) {
            super(row0, row1, chain, cidx, data, rows, cols);
        }

        public ConstRangeMatrix(int[] ridx, Address.MatrixAddress chain, int[] cidx, double[] data, int rows, int cols) {
            super(ridx, chain, cidx, data, rows, cols);
        }

        @Override
        public void set(int row, int col, double value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ConstRangeCol
    extends RangeCol {
        public ConstRangeCol(int row0, int row1, Address.MatrixAddress chain, int col, double[] data, int rows, int cols) {
            super(row0, row1, chain, col, data, rows, cols);
        }

        @Override
        public void set(int pos, double value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ConstRangeRow
    extends RangeRow {
        public ConstRangeRow(int row, Address.MatrixAddress chain, int col0, int col1, double[] data, int rows, int cols) {
            super(row, chain, col0, col1, data, rows, cols);
        }

        @Override
        public void set(int pos, double value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class RangeMatrix
    extends Matrix {
        public RangeMatrix(int row0, int row1, Address.MatrixAddress chain, int col0, int col1, boolean contiguous, double[] data, int rows, int cols) {
            super(row1 - row0, col1 - col0, data, new DirectMatrixAddress(data, row0, row1, chain, col0, col1, null, true, rows, cols));
        }

        public RangeMatrix(int[] ridx, Address.MatrixAddress chain, int col0, int col1, double[] data, int rows, int cols) {
            super(ridx.length, col1 - col0, data, new MappedMatrixAddress(data, ridx, chain, col0, col1, null, true, rows, cols));
        }

        public RangeMatrix(int row0, int row1, Address.MatrixAddress chain, int[] cidx, double[] data, int rows, int cols) {
            super(row1 - row0, cidx.length, data, new MappedMatrixAddress(data, row0, row1, chain, cidx, null, true, rows, cols));
        }

        public RangeMatrix(int[] ridx, Address.MatrixAddress chain, int[] cidx, double[] data, int rows, int cols) {
            super(ridx.length, cidx.length, data, new MappedMatrixAddress(data, ridx, chain, cidx, null, true, rows, cols));
        }
    }

    private static class RangeCol
    extends Array {
        public RangeCol(int row0, int row1, Address.MatrixAddress chain, int col, double[] data, int rows, int cols) {
            super(row1 - row0, 1, data, new DirectArrayColAddress(data, row0, row1, chain, col, null, true, rows, cols));
        }
    }

    private static class RangeRow
    extends Array {
        public RangeRow(int row, Address.MatrixAddress chain, int col0, int col1, double[] data, int rows, int cols) {
            super(1, col1 - col0, data, new DirectArrayRowAddress(data, row, chain, col0, col1, null, true, rows, cols));
        }
    }
}

