/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.interpolations;

import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.interpolations.DefaultExtrapolator;
import org.jquantlib.math.interpolations.Interpolation2D;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;

public class AbstractInterpolation2D
implements Interpolation2D {
    protected Impl impl_;
    private final DefaultExtrapolator delegatedExtrapolator = new DefaultExtrapolator();

    @Override
    public boolean empty() {
        return this.impl_ == null;
    }

    @Override
    public double op(double x, double y) {
        return this.op(x, y, false);
    }

    @Override
    public double op(double x, double y, boolean allowExtrapolation) {
        this.checkRange(x, y, allowExtrapolation);
        return this.impl_.op(x, y);
    }

    @Override
    public double xMin() {
        return this.impl_.xMin();
    }

    @Override
    public double xMax() {
        return this.impl_.xMax();
    }

    @Override
    public double yMin() {
        return this.impl_.yMin();
    }

    @Override
    public double yMax() {
        return this.impl_.yMax();
    }

    @Override
    public int locateX(double x) {
        return this.impl_.locateX(x);
    }

    @Override
    public int locateY(double y) {
        return this.impl_.locateY(y);
    }

    @Override
    public boolean isInRange(double x, double y) {
        return this.impl_.isInRange(x, y);
    }

    @Override
    public void update() {
        this.impl_.calculate();
    }

    protected final void checkRange(double x, double y, boolean extrapolate) {
        if (!(extrapolate || this.allowsExtrapolation() || this.isInRange(x, y))) {
            StringBuilder sb = new StringBuilder();
            sb.append("interpolation range is [");
            sb.append(this.xMin()).append(", ").append(this.xMax());
            sb.append("] x [");
            sb.append(this.yMin()).append(", ").append(this.yMax());
            sb.append("]: extrapolation at (");
            sb.append(x).append(",").append(y);
            sb.append(") not allowed");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    public final boolean allowsExtrapolation() {
        return this.delegatedExtrapolator.allowsExtrapolation();
    }

    @Override
    public void disableExtrapolation() {
        this.delegatedExtrapolator.disableExtrapolation();
    }

    @Override
    public void enableExtrapolation() {
        this.delegatedExtrapolator.enableExtrapolation();
    }

    protected abstract class Impl {
        protected Array vx;
        protected Array vy;
        protected Matrix mz;

        protected Impl() {
        }

        protected Impl(Array vx, Array vy, Matrix mz) {
            this.vx = vx;
            this.vy = vy;
            this.mz = mz;
            QL.require(vx.size() >= 2 && vy.size() >= 2, "not enough points to interpolate");
            for (int i = 0; i < vx.size() - 1; ++i) {
                QL.require(vx.get(i) <= vx.get(i + 1), "unsorted values on array X");
                QL.require(vy.get(i) <= vy.get(i + 1), "unsorted values on array Y");
            }
        }

        public double xMin() {
            return this.vx.first();
        }

        public double xMax() {
            return this.vx.last();
        }

        public double yMin() {
            return this.vy.first();
        }

        public double yMax() {
            return this.vy.last();
        }

        public double op(double x, double y, boolean allowExtrapolation) {
            AbstractInterpolation2D.this.checkRange(x, y, allowExtrapolation);
            return this.op(x, y);
        }

        public boolean isInRange(double x, double y) {
            boolean xIsInrange;
            QL.require(this.extraSafetyChecksX(), "unsorted values on array X");
            double x1 = this.xMin();
            double x2 = this.xMax();
            boolean bl = xIsInrange = x >= x1 && x <= x2 || Closeness.isClose(x, x1) || Closeness.isClose(x, x2);
            if (!xIsInrange) {
                return false;
            }
            QL.require(this.extraSafetyChecksY(), "unsorted values on array Y");
            double y1 = this.yMin();
            double y2 = this.yMax();
            return y >= y1 && y <= y2 || Closeness.isClose(y, y1) || Closeness.isClose(y, y2);
        }

        public abstract double op(double var1, double var3);

        public abstract void calculate();

        protected int locateX(double x) {
            QL.require(this.extraSafetyChecksX(), "unsorted values on array X");
            if (x <= this.vx.first()) {
                return 0;
            }
            if (x > this.vx.last()) {
                return this.vx.size() - 2;
            }
            return this.vx.upperBound(x) - 1;
        }

        protected int locateY(double y) {
            QL.require(this.extraSafetyChecksY(), "unsorted values on array Y");
            if (y <= this.vy.first()) {
                return 0;
            }
            if (y > this.vy.last()) {
                return this.vy.size() - 2;
            }
            return this.vy.upperBound(y) - 1;
        }

        private boolean extraSafetyChecksX() {
            if (new Settings().isExtraSafetyChecks()) {
                for (int i = 0; i < this.vx.size() - 1; ++i) {
                    if (!(this.vx.get(i) > this.vx.get(i + 1))) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean extraSafetyChecksY() {
            if (new Settings().isExtraSafetyChecks()) {
                for (int i = 0; i < this.vy.size() - 1; ++i) {
                    if (!(this.vy.get(i) > this.vy.get(i + 1))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

