/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.integrals;

import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Ops;
import org.jquantlib.math.integrals.Integrator;

public class TrapezoidIntegral<T extends IntegrationPolicy>
extends Integrator {
    protected final IntegrationPolicy policy;

    public TrapezoidIntegral(Class<? extends IntegrationPolicy> klass, double accuracy, int maxEvaluations) {
        super(accuracy, maxEvaluations);
        if (klass == Default.class) {
            this.policy = new Default();
        } else if (klass == MidPoint.class) {
            this.policy = new MidPoint();
        } else {
            throw new LibraryException("Unexpected type for type parameter");
        }
    }

    @Override
    protected double integrate(Ops.DoubleOp f, double a, double b) {
        int N = 1;
        double I = (f.op(a) + f.op(b)) * (b - a) / 2.0;
        int i = 1;
        do {
            double newI = this.policy.integrate(f, a, b, I, N);
            N *= this.policy.nbEvalutions();
            if (Math.abs(I - newI) <= super.absoluteAccuracy() && i > 5) {
                return newI;
            }
            I = newI;
        } while (++i < super.maxEvaluations());
        throw new ArithmeticException("max number of iterations reached");
    }

    public static class MidPoint
    implements IntegrationPolicy {
        @Override
        public double integrate(Ops.DoubleOp f, double a, double b, double I, int N) {
            double sum = 0.0;
            double dx = (b - a) / (double)N;
            double x = a + dx / 6.0;
            double D = 2.0 * dx / 3.0;
            for (int i = 0; i < N; ++i) {
                sum += f.op(x) + f.op(x + D);
                x += dx;
            }
            return (I + dx * sum) / 3.0;
        }

        @Override
        public int nbEvalutions() {
            return 3;
        }
    }

    public static class Default
    implements IntegrationPolicy {
        @Override
        public double integrate(Ops.DoubleOp f, double a, double b, double I, int N) {
            double sum = 0.0;
            double dx = (b - a) / (double)N;
            double x = a + dx / 2.0;
            for (int i = 0; i < N; ++i) {
                sum += f.op(x);
                x += dx;
            }
            return (I + dx * sum) / 2.0;
        }

        @Override
        public int nbEvalutions() {
            return 2;
        }
    }

    protected static interface IntegrationPolicy {
        public double integrate(Ops.DoubleOp var1, double var2, double var4, double var6, int var8);

        public int nbEvalutions();
    }
}

