/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.Beta;
import org.jquantlib.math.Ops;

public class CumulativeBinomialDistribution
implements Ops.IntToDouble {
    private static final String INVALID_PROBABILITY = "probability must be 0.0 <= p <= 1.0";
    private static final double accuracy = 1.0E-16;
    private static final int maxIteration = 100;
    private final int n;
    private final double p;

    public CumulativeBinomialDistribution(double p, int n) {
        QL.require(p >= 0.0 && p <= 1.0, INVALID_PROBABILITY);
        this.n = n;
        this.p = p;
    }

    @Override
    public double op(int k) {
        if (k >= this.n) {
            return 1.0;
        }
        return 1.0 - Beta.incompleteBetaFunction(k + 1, this.n - k, this.p, 1.0E-16, 100);
    }
}

