/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.Ops;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.integrals.TabulatedGaussLegendre;

public class BivariateNormalDistribution
implements Ops.BinaryDoubleOp {
    private final double correlation;
    private static final CumulativeNormalDistribution cumnorm = new CumulativeNormalDistribution();

    public BivariateNormalDistribution(double rho) {
        QL.require(rho >= -1.0 && rho <= 1.0, "rho must be >= -1.0 and <= 1.0");
        this.correlation = rho;
    }

    @Override
    public double op(double x, double y) {
        TabulatedGaussLegendre gaussLegendreQuad = new TabulatedGaussLegendre(20);
        if (Math.abs(this.correlation) < 0.3) {
            gaussLegendreQuad.setOrder(6);
        } else if (Math.abs(this.correlation) < 0.75) {
            gaussLegendreQuad.setOrder(12);
        }
        double h = -x;
        double k = -y;
        double hk = h * k;
        double bvn = 0.0;
        if (Math.abs(this.correlation) < 0.925) {
            if (Math.abs(this.correlation) > 0.0) {
                double asr = Math.asin(this.correlation);
                Eqn3 f = new Eqn3(h, k, asr);
                bvn = gaussLegendreQuad.evaluate(f);
                bvn *= asr * 0.07957747154594767;
            }
            bvn += cumnorm.op(-h) * cumnorm.op(-k);
        } else {
            if (this.correlation < 0.0) {
                k *= -1.0;
                hk *= -1.0;
            }
            if (Math.abs(this.correlation) < 1.0) {
                double Ass = (1.0 - this.correlation) * (1.0 + this.correlation);
                double a = Math.sqrt(Ass);
                double bs = (h - k) * (h - k);
                double c = (4.0 - hk) / 8.0;
                double d = (12.0 - hk) / 16.0;
                double asr = -(bs / Ass + hk) / 2.0;
                if (asr > -100.0) {
                    bvn = a * Math.exp(asr) * (1.0 - c * (bs - Ass) * (1.0 - d * bs / 5.0) / 3.0 + c * d * Ass * Ass / 5.0);
                }
                if (-hk < 100.0) {
                    double B = Math.sqrt(bs);
                    bvn -= Math.exp(-hk / 2.0) * 2.5066282746310007 * cumnorm.op(-B / a) * B * (1.0 - c * bs * (1.0 - d * bs / 5.0) / 3.0);
                }
                Eqn6 f = new Eqn6(a /= 2.0, c, d, bs, hk);
                bvn += gaussLegendreQuad.evaluate(f);
                bvn /= Math.PI * -2;
            }
            if (this.correlation > 0.0) {
                bvn += cumnorm.op(-Math.max(h, k));
            } else {
                bvn *= -1.0;
                if (k > h) {
                    bvn += cumnorm.op(k) - cumnorm.op(h);
                }
            }
        }
        return bvn;
    }

    private static class Eqn6
    implements Ops.DoubleOp {
        private final double a;
        private final double c;
        private final double d;
        private final double bs;
        private final double hk;

        public Eqn6(double a, double c, double d, double bs, double hk) {
            this.a = a;
            this.c = c;
            this.d = d;
            this.bs = bs;
            this.hk = hk;
        }

        @Override
        public double op(double x) {
            double xs = this.a * (-x + 1.0);
            xs = Math.abs(xs * xs);
            double rs = Math.sqrt(1.0 - xs);
            double asr = -(this.bs / xs + this.hk) / 2.0;
            if (asr > -100.0) {
                return this.a * Math.exp(asr) * (Math.exp(-this.hk * (1.0 - rs) / (2.0 * (1.0 + rs))) / rs - (1.0 + this.c * xs * (1.0 + this.d * xs)));
            }
            return 0.0;
        }
    }

    private static class Eqn3
    implements Ops.DoubleOp {
        private final double hk;
        private final double asr;
        private final double hs;

        public Eqn3(double h, double k, double asr) {
            this.hk = h * k;
            this.hs = (h * h + k * k) / 2.0;
            this.asr = asr;
        }

        @Override
        public double op(double x) {
            double sn = Math.sin(this.asr * (-x + 1.0) * 0.5);
            return Math.exp((sn * this.hk - this.hs) / (1.0 - sn * sn));
        }
    }
}

