/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Ops;
import org.jquantlib.math.matrixutilities.Array;

public class TransformedGrid {
    protected Array grid;
    protected Array transformedGrid;
    protected Array dxm;
    protected Array dxp;
    protected Array dx;

    public TransformedGrid(Array grid) {
        this.grid = grid;
        this.transformedGrid = grid.clone();
        this.dxm = new Array(grid.size());
        this.dxp = new Array(grid.size());
        this.dx = new Array(grid.size());
        for (int i = 1; i < this.transformedGrid.size() - 1; ++i) {
            this.dxm.set(i, this.transformedGrid.get(i) - this.transformedGrid.get(i - 1));
            this.dxp.set(i, this.transformedGrid.get(i + 1) - this.transformedGrid.get(i));
            this.dx.set(i, this.dxm.get(i) + this.dxp.get(i));
        }
    }

    public TransformedGrid(Array grid, Ops.DoubleOp f) {
        this.grid = grid;
        this.transformedGrid = grid.clone().transform(f);
        this.dxm = new Array(grid.size());
        this.dxp = new Array(grid.size());
        this.dx = new Array(grid.size());
        for (int i = 1; i < this.transformedGrid.size() - 1; ++i) {
            this.dxm.set(i, this.transformedGrid.get(i) - this.transformedGrid.get(i - 1));
            this.dxp.set(i, this.transformedGrid.get(i + 1) - this.transformedGrid.get(i));
            this.dx.set(i, this.dxm.get(i) + this.dxp.get(i));
        }
    }

    public Array gridArray() {
        return this.grid;
    }

    public Array transformedGridArray() {
        return this.transformedGrid;
    }

    public Array dxmArray() {
        return this.dxm;
    }

    public Array dxpArray() {
        return this.dxp;
    }

    public Array dxArray() {
        return this.dx;
    }

    public double grid(int i) {
        return this.grid.get(i);
    }

    public double transformedGrid(int i) {
        return this.transformedGrid.get(i);
    }

    public double dxm(int i) {
        return this.dxm.get(i);
    }

    public double dxp(int i) {
        return this.dxp.get(i);
    }

    public double dx(int i) {
        return this.dx.get(i);
    }

    public int size() {
        return this.grid.size();
    }
}

