/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.QL;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Grid;
import org.jquantlib.math.Ops;
import org.jquantlib.math.functions.Identity;
import org.jquantlib.math.interpolations.NaturalCubicInterpolation;
import org.jquantlib.math.matrixutilities.Array;

public class SampledCurve
implements Cloneable {
    private Array grid;
    private Array values;

    public SampledCurve(int gridSize) {
        this.grid = new Array(gridSize);
        this.values = new Array(gridSize);
    }

    public SampledCurve(Array grid) {
        this.grid = grid;
        this.values = new Array(this.grid.size());
    }

    public SampledCurve(SampledCurve that) {
        this.grid = that.grid.clone();
        this.values = that.values.clone();
    }

    public SampledCurve clone() {
        try {
            return (SampledCurve)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new LibraryException(e);
        }
    }

    public int size() {
        return this.grid.size();
    }

    public SampledCurve swap(SampledCurve another) {
        this.grid.swap(another.grid);
        this.values.swap(another.values);
        return this;
    }

    public Array grid() {
        return this.grid;
    }

    public Array values() {
        return this.values;
    }

    public double gridValue(int i) {
        return this.grid.get(i);
    }

    public double value(int i) {
        return this.values.get(i);
    }

    private boolean empty() {
        return this.grid.empty();
    }

    public void setGrid(Array g) {
        this.grid = g;
    }

    public void setValues(Array array) {
        this.values = array;
    }

    public void setLogGrid(double min, double max) {
        this.setGrid(Grid.BoundedLogGrid(min, max, this.size() - 1));
    }

    public <T extends Ops.DoubleOp> void sample(T func) {
        for (int i = 0; i < this.grid.size(); ++i) {
            double v = func.op(this.grid.get(i));
            this.values.set(i, v);
        }
    }

    public void shiftGrid(double s) {
        this.grid.addAssign(s);
    }

    public void scaleGrid(double s) {
        this.grid.mulAssign(s);
    }

    public double valueAtCenter() {
        QL.require(!this.empty(), "empty sampled curve");
        int jmid = this.size() / 2;
        if (this.size() % 2 != 0) {
            return this.values.get(jmid);
        }
        return (this.values.get(jmid) + this.values.get(jmid - 1)) / 2.0;
    }

    public double firstDerivativeAtCenter() {
        QL.require(this.size() >= 3, "the size of the curve must be at least 3");
        int jmid = this.size() / 2;
        if (this.size() % 2 != 0) {
            return (this.values.get(jmid + 1) - this.values.get(jmid - 1)) / (this.grid.get(jmid + 1) - this.grid.get(jmid - 1));
        }
        return (this.values.get(jmid) - this.values.get(jmid - 1)) / (this.grid.get(jmid) - this.grid.get(jmid - 1));
    }

    public double secondDerivativeAtCenter() {
        QL.require(this.size() >= 4, "the size of the curve must be at least 4");
        int jmid = this.size() / 2;
        if (this.size() % 2 != 0) {
            double deltaPlus = (this.values.get(jmid + 1) - this.values.get(jmid)) / (this.grid.get(jmid + 1) - this.grid.get(jmid));
            double deltaMinus = (this.values.get(jmid) - this.values.get(jmid - 1)) / (this.grid.get(jmid) - this.grid.get(jmid - 1));
            double dS = (this.grid.get(jmid + 1) - this.grid.get(jmid - 1)) / 2.0;
            return (deltaPlus - deltaMinus) / dS;
        }
        double deltaPlus = (this.values.get(jmid + 1) - this.values.get(jmid - 1)) / (this.grid.get(jmid + 1) - this.grid.get(jmid - 1));
        double deltaMinus = (this.values.get(jmid) - this.values.get(jmid - 2)) / (this.grid.get(jmid) - this.grid.get(jmid - 2));
        return (deltaPlus - deltaMinus) / (this.grid.get(jmid) - this.grid.get(jmid - 1));
    }

    public void regrid(Array newGrid) {
        this.regrid(newGrid, new Identity());
    }

    public void regrid(Array newGrid, Ops.DoubleOp f) {
        Array newValues;
        Array transformed;
        if (f instanceof Identity) {
            transformed = this.grid;
            newValues = newGrid.clone();
        } else {
            transformed = this.grid.clone().transform(f);
            newValues = newGrid.clone().transform(f);
        }
        NaturalCubicInterpolation priceSpline = new NaturalCubicInterpolation(transformed, this.values);
        priceSpline.update();
        for (int i = 0; i < newValues.size(); ++i) {
            newValues.set(i, priceSpline.op(newValues.get(i), true));
        }
        this.grid.swap(newGrid);
        this.values.swap(newValues);
    }
}

