/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.lang.exceptions.LibraryException;

public class Rounding {
    private int precision_;
    public Type type_;
    private int digit_;

    public Rounding() {
        this.type_ = Type.None;
    }

    public Rounding(int precision) {
        this(precision, Type.Closest, 5);
    }

    public Rounding(int precision, Type type, int digit) {
        this.precision_ = precision;
        this.type_ = type;
        this.digit_ = digit;
    }

    public int precision() {
        return this.precision_;
    }

    public Type type() {
        return this.type_;
    }

    public int roundingDigit() {
        return this.digit_;
    }

    public final double operator(double value) {
        if (this.type_ == Type.None) {
            return value;
        }
        double mult = Math.pow(10.0, this.precision_);
        boolean neg = value < 0.0;
        double lvalue = Math.abs(value) * mult;
        double integral = (int)lvalue;
        double modVal = lvalue - (double)((int)lvalue);
        lvalue -= modVal;
        switch (this.type_) {
            case Down: {
                break;
            }
            case Up: {
                lvalue += 1.0;
                break;
            }
            case Closest: {
                if (!(modVal >= (double)this.digit_ / 10.0)) break;
                lvalue += 1.0;
                break;
            }
            case Floor: {
                if (neg || !(modVal >= (double)this.digit_ / 10.0)) break;
                lvalue += 1.0;
                break;
            }
            case Ceiling: {
                if (!neg || !(modVal >= (double)this.digit_ / 10.0)) break;
                lvalue += 1.0;
                break;
            }
            default: {
                throw new LibraryException("unknown rounding method");
            }
        }
        return neg ? -(lvalue / mult) : lvalue / mult;
    }

    public static class FloorTruncation
    extends Rounding {
        public FloorTruncation(int precision) {
            this(precision, 5);
        }

        public FloorTruncation(int precision, int digit) {
            super(precision, Type.Floor, digit);
        }
    }

    public static class CeilingTruncation
    extends Rounding {
        public CeilingTruncation(int precision) {
            this(precision, 5);
        }

        public CeilingTruncation(int precision, int digit) {
            super(precision, Type.Ceiling, digit);
        }
    }

    public static class ClosestRounding
    extends Rounding {
        public ClosestRounding(int precision) {
            this(precision, 5);
        }

        public ClosestRounding(int precision, int digit) {
            super(precision, Type.Closest, digit);
        }
    }

    public static class DownRounding
    extends Rounding {
        public DownRounding(int precision) {
            this(precision, 5);
        }

        public DownRounding(int precision, int digit) {
            super(precision, Type.Down, digit);
        }
    }

    public static class UpRounding
    extends Rounding {
        public UpRounding(int precision) {
            this(precision, 5);
        }

        public UpRounding(int precision, int digit) {
            super(precision, Type.Up, digit);
        }
    }

    public static enum Type {
        None,
        Up,
        Down,
        Closest,
        Floor,
        Ceiling;

    }
}

