/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.matrixutilities.Array;

public final class Grid {
    private Grid() {
    }

    public static final Array CenteredGrid(double center, double dx, int steps) {
        Array result = new Array(steps + 1);
        for (int i = 0; i < steps + 1; ++i) {
            result.set(i, center + ((double)i - (double)steps / 2.0) * dx);
        }
        return result;
    }

    public static final Array BoundedGrid(double xMin, double xMax, int steps) {
        Array result = new Array(steps + 1);
        double dx = (xMax - xMin) / (double)steps;
        double x = xMin;
        int i = 0;
        while (i < steps + 1) {
            result.set(i, x);
            ++i;
            x += dx;
        }
        return result;
    }

    public static final Array BoundedLogGrid(double xMin, double xMax, int steps) {
        Array result = new Array(steps + 1);
        double gridLogSpacing = (Math.log(xMax) - Math.log(xMin)) / (double)steps;
        double edx = Math.exp(gridLogSpacing);
        result.set(0, xMin);
        for (int j = 1; j < steps + 1; ++j) {
            result.set(j, result.get(j - 1) * edx);
        }
        return result;
    }
}

