/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.GammaFunction;

public class Beta {
    static double betaContinuedFraction(double a, double b, double x, double accuracy, double maxIteration) {
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double c = 1.0;
        double d = 1.0 - qab * x / qap;
        if (Math.abs(d) < Constants.QL_EPSILON) {
            d = Constants.QL_EPSILON;
        }
        double result = d = 1.0 / d;
        Integer m = 1;
        while ((double)m.intValue() <= maxIteration) {
            Integer m2 = 2 * m;
            double aa = (double)m.intValue() * (b - (double)m.intValue()) * x / ((qam + (double)m2.intValue()) * (a + (double)m2.intValue()));
            d = 1.0 + aa * d;
            if (Math.abs(d) < Constants.QL_EPSILON) {
                d = Constants.QL_EPSILON;
            }
            if (Math.abs(c = 1.0 + aa / c) < Constants.QL_EPSILON) {
                c = Constants.QL_EPSILON;
            }
            d = 1.0 / d;
            result *= d * c;
            aa = -(a + (double)m.intValue()) * (qab + (double)m.intValue()) * x / ((a + (double)m2.intValue()) * (qap + (double)m2.intValue()));
            d = 1.0 + aa * d;
            if (Math.abs(d) < Constants.QL_EPSILON) {
                d = Constants.QL_EPSILON;
            }
            if (Math.abs(c = 1.0 + aa / c) < Constants.QL_EPSILON) {
                c = Constants.QL_EPSILON;
            }
            d = 1.0 / d;
            double del = d * c;
            result *= del;
            if (Math.abs(del - 1.0) < accuracy) {
                return result;
            }
            Integer n = m;
            Integer n2 = m = Integer.valueOf(m + 1);
        }
        throw new ArithmeticException("a or b too big, or maxIteration too small in betacf");
    }

    public static double incompleteBetaFunction(double a, double b, double x, double accuracy, Integer maxIteration) {
        GammaFunction gf = new GammaFunction();
        QL.require(a > 0.0, "a must be greater than zero");
        QL.require(b > 0.0, "b must be greater than zero");
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        if (x < 0.0 || x > 1.0) {
            throw new ArithmeticException("x must be in [0,1]");
        }
        double result = Math.exp(gf.logValue(a + b) - gf.logValue(a) - gf.logValue(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return result * Beta.betaContinuedFraction(a, b, x, accuracy, maxIteration.intValue()) / a;
        }
        return 1.0 - result * Beta.betaContinuedFraction(b, a, 1.0 - x, accuracy, maxIteration.intValue()) / b;
    }

    static double betaFunction(double z, double w) {
        GammaFunction gf = new GammaFunction();
        return Math.exp(gf.logValue(z) + gf.logValue(w) - gf.logValue(z + w));
    }
}

