/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.legacy.libormarkets;

import org.jquantlib.legacy.libormarkets.LmCorrelationModel;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.PseudoSqrt;
import org.jquantlib.math.optimization.BoundaryConstraint;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.model.ConstantParameter;
import org.jquantlib.model.Parameter;

public class LmLinearExponentialCorrelationModel
extends LmCorrelationModel {
    private Matrix corrMatrix_;
    private Matrix pseudoSqrt_;
    private int factors_;

    public LmLinearExponentialCorrelationModel(int size, double rho, double beta, int factors) {
        super(size, 2);
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.corrMatrix_ = new Matrix(size, size);
        factors = factors != 0 ? 0 : size;
        this.arguments_.set(0, new ConstantParameter(rho, new BoundaryConstraint(-1.0, 1.0)));
        this.arguments_.set(1, new ConstantParameter(beta, new PositiveConstraint()));
        this.generateArguments();
    }

    public LmLinearExponentialCorrelationModel(int size, double rho, double beta) {
        this(size, rho, beta, 0);
    }

    @Override
    public Matrix correlation(double time, Array x) {
        return this.corrMatrix_;
    }

    @Override
    public double correlation(int i, int j, double time, Array x) {
        return this.corrMatrix_.get(i, j);
    }

    @Override
    public boolean isTimeIndependent() {
        return true;
    }

    @Override
    public int factors() {
        return this.factors_;
    }

    @Override
    public Matrix pseudoSqrt(double time, Array x) {
        return this.pseudoSqrt_;
    }

    @Override
    public void generateArguments() {
        double rho = ((Parameter)this.arguments_.get(0)).get(0.0);
        double beta = ((Parameter)this.arguments_.get(1)).get(0.0);
        for (int i = 0; i < this.size_; ++i) {
            for (int j = i; j < this.size_; ++j) {
                double value = rho + (1.0 - rho) * Math.exp(-beta * (double)Math.abs(i - j));
                this.corrMatrix_.set(i, j, value);
                this.corrMatrix_.set(j, i, value);
            }
        }
        this.pseudoSqrt_ = PseudoSqrt.rankReducedSqrt(this.corrMatrix_, this.factors_, 1, PseudoSqrt.SalvagingAlgorithm.None);
        this.corrMatrix_ = this.pseudoSqrt_.mul(this.pseudoSqrt_).mul(this.pseudoSqrt_.transpose());
    }
}

