/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments.bonds;

import org.jquantlib.QL;
import org.jquantlib.cashflow.IborLeg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.instruments.Bond;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.quotes.Handle;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;

public class FloatingRateBond
extends Bond {
    public FloatingRateBond(int settlementDays, double faceAmount, Schedule schedule, IborIndex index, DayCounter paymentDayCounter, BusinessDayConvention paymentConvention, int fixingDays, Array gearings, Array spreads, Array caps, Array floors, boolean inArrears, double redemption, Date issueDate) {
        super(settlementDays, schedule.calendar(), issueDate);
        this.maturityDate_ = schedule.endDate().clone();
        this.cashflows_ = new IborLeg(schedule, index).withNotionals(faceAmount).withPaymentDayCounter(paymentDayCounter).withPaymentAdjustment(paymentConvention).withFixingDays(fixingDays).withGearings(gearings).withSpreads(spreads).withCaps(caps).withFloors(floors).inArrears(inArrears).Leg();
        this.addRedemptionsToCashflows(new double[]{redemption});
        QL.ensure(!this.cashflows().isEmpty(), "bond with no cashflows!");
        QL.ensure(this.redemptions_.size() == 1, "multiple redemptions created");
        index.addObserver(this);
    }

    public FloatingRateBond(int settlementDays, double faceAmount, Schedule schedule, IborIndex index, DayCounter accrualDayCounter) {
        this(settlementDays, faceAmount, schedule, index, accrualDayCounter, BusinessDayConvention.Following, Integer.MAX_VALUE, new Array(new double[]{1.0}), new Array(new double[]{0.0}), new Array(0), new Array(0), false, 100.0, new Date());
    }

    public FloatingRateBond(int settlementDays, double faceAmount, Date startDate, Date maturityDate, Frequency couponFrequency, Calendar calendar, Handle<IborIndex> index, DayCounter accrualDayCounter, BusinessDayConvention accrualConvention, BusinessDayConvention paymentConvention, int fixingDays, Array gearings, Array spreads, Array caps, Array floors, boolean inArrears, double redemption, Date issueDate, Date stubDate, DateGeneration.Rule rule, boolean endOfMonth) {
        super(settlementDays, calendar, issueDate);
        this.maturityDate_ = maturityDate.clone();
        Date firstDate = null;
        Date nextToLastDate = null;
        switch (rule) {
            case Backward: {
                firstDate = new Date();
                nextToLastDate = stubDate;
                break;
            }
            case Forward: {
                firstDate = stubDate;
                nextToLastDate = new Date();
                break;
            }
            case Zero: 
            case ThirdWednesday: 
            case Twentieth: 
            case TwentiethIMM: {
                QL.error("stub date (" + stubDate + ") not allowed with " + (Object)((Object)rule) + " DateGeneration::Rule");
            }
            default: {
                QL.error("unknown DateGeneration::Rule (" + (Object)((Object)rule) + ")");
            }
        }
        Schedule schedule = new Schedule(startDate, this.maturityDate_, new Period(couponFrequency), this.calendar_, accrualConvention, accrualConvention, rule, endOfMonth, firstDate, nextToLastDate);
        this.cashflows_ = new IborLeg(schedule, index.currentLink()).withNotionals(faceAmount).withPaymentDayCounter(accrualDayCounter).withPaymentAdjustment(paymentConvention).withFixingDays(fixingDays).withGearings(gearings).withSpreads(spreads).withCaps(caps).withFloors(floors).inArrears(inArrears).Leg();
        this.addRedemptionsToCashflows(new double[]{redemption});
        QL.ensure(!this.cashflows().isEmpty(), "bond with no cashflows!");
        QL.ensure(this.redemptions_.size() == 1, "multiple redemptions created");
        index.addObserver(this);
    }

    public FloatingRateBond(int settlementDays, double faceAmount, Date startDate, Date maturityDate, Frequency couponFrequency, Calendar calendar, Handle<IborIndex> index, DayCounter accrualDayCounter) {
        this(settlementDays, faceAmount, startDate, maturityDate, couponFrequency, calendar, index, accrualDayCounter, BusinessDayConvention.Following, BusinessDayConvention.Following, Integer.MAX_VALUE, new Array(new double[]{1.0}), new Array(new double[]{0.0}), new Array(0), new Array(0), false, 100.0, new Date(), new Date(), DateGeneration.Rule.Backward, false);
    }
}

