/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments.bonds;

import org.jquantlib.QL;
import org.jquantlib.cashflow.IborLeg;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.instruments.CallabilitySchedule;
import org.jquantlib.instruments.DividendSchedule;
import org.jquantlib.instruments.bonds.ConvertibleBond;
import org.jquantlib.instruments.bonds.ConvertibleBondOption;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.time.Date;
import org.jquantlib.time.Schedule;

public class ConvertibleFloatingRateBond
extends ConvertibleBond {
    public ConvertibleFloatingRateBond(Exercise exercise, double conversionRatio, DividendSchedule dividends, CallabilitySchedule callability, Handle<Quote> creditSpread, Date issueDate, int settlementDays, IborIndex index, int fixingDays, double[] spreads, DayCounter dayCounter, Schedule schedule) {
        this(exercise, conversionRatio, dividends, callability, creditSpread, issueDate, settlementDays, index, fixingDays, spreads, dayCounter, schedule, 100.0);
    }

    public ConvertibleFloatingRateBond(Exercise exercise, double conversionRatio, DividendSchedule dividends, CallabilitySchedule callability, Handle<Quote> creditSpread, Date issueDate, int settlementDays, IborIndex index, int fixingDays, double[] spreads, DayCounter dayCounter, Schedule schedule, double redemption) {
        super(exercise, conversionRatio, dividends, callability, creditSpread, issueDate, settlementDays, dayCounter, schedule, redemption);
        this.cashflows_ = new IborLeg(schedule, index).withPaymentDayCounter(dayCounter).withNotionals(100.0).withPaymentAdjustment(schedule.businessDayConvention()).withFixingDays(fixingDays).withSpreads(new Array(spreads)).Leg();
        this.addRedemptionsToCashflows(new double[]{redemption});
        QL.ensure(this.redemptions_.size() == 1, "multiple redemptions created");
        this.option = new ConvertibleBondOption(this, exercise, conversionRatio, dividends, callability, creditSpread, this.cashflows_, dayCounter, schedule, issueDate, settlementDays, redemption);
    }
}

