/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.instruments.Instrument;
import org.jquantlib.math.Ops;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.quotes.SimpleQuote;

public class PriceError
implements Ops.DoubleOp {
    private final PricingEngine engine;
    private final Instrument.ResultsImpl results;
    private final SimpleQuote vol;
    private final double targetValue;

    public PriceError(PricingEngine engine, SimpleQuote vol, double targetValue) {
        this.engine = engine;
        this.vol = vol;
        this.targetValue = targetValue;
        this.results = (Instrument.ResultsImpl)engine.getResults();
        QL.require(this.results != null, "pricing engine does not supply needed results");
    }

    @Override
    public double op(double x) {
        this.vol.setValue(x);
        this.engine.calculate();
        return this.results.value - this.targetValue;
    }
}

