/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.QL;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.Position;
import org.jquantlib.lang.exceptions.LibraryException;

public class ForwardTypePayoff
extends Payoff {
    protected double strike;
    protected Position type;

    public ForwardTypePayoff(Position positionType, double strike) {
        QL.require(strike >= 0.0, "negative strike given");
        this.strike = strike;
        this.type = positionType;
    }

    public final double strike() {
        return this.strike;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name());
        sb.append(this.type.toString());
        sb.append(" ");
        sb.append(this.strike);
        return sb.toString();
    }

    @Override
    public final double get(double price) {
        if (this.type == Position.Long) {
            return price - this.strike;
        }
        if (this.type == Position.Short) {
            return this.strike - price;
        }
        throw new LibraryException(" Unknown Forward Type ");
    }

    @Override
    public String name() {
        return "Forward";
    }
}

